/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents impact of an operation, both in absolute and relative terms.
 */
public class OperationImpact {
    /**
     * The name of the impact dimension.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The unit in which estimated impact to dimension is measured.
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /**
     * The absolute impact to dimension.
     */
    @JsonProperty(value = "changeValueAbsolute", access = JsonProperty.Access.WRITE_ONLY)
    private Double changeValueAbsolute;

    /**
     * The relative impact to dimension (null if not applicable).
     */
    @JsonProperty(value = "changeValueRelative", access = JsonProperty.Access.WRITE_ONLY)
    private Double changeValueRelative;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the unit value.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the changeValueAbsolute value.
     *
     * @return the changeValueAbsolute value
     */
    public Double changeValueAbsolute() {
        return this.changeValueAbsolute;
    }

    /**
     * Get the changeValueRelative value.
     *
     * @return the changeValueRelative value
     */
    public Double changeValueRelative() {
        return this.changeValueRelative;
    }

}
