/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for RecommendedIndexTypes.
 */
public enum RecommendedIndexTypes {
    /** Enum value CLUSTERED. */
    CLUSTERED("CLUSTERED"),

    /** Enum value NONCLUSTERED. */
    NONCLUSTERED("NONCLUSTERED"),

    /** Enum value COLUMNSTORE. */
    COLUMNSTORE("COLUMNSTORE"),

    /** Enum value CLUSTERED COLUMNSTORE. */
    CLUSTERED_COLUMNSTORE("CLUSTERED COLUMNSTORE");

    /** The actual serialized value for a RecommendedIndexTypes instance. */
    private String value;

    RecommendedIndexTypes(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a RecommendedIndexTypes instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed RecommendedIndexTypes object, or null if unable to parse.
     */
    @JsonCreator
    public static RecommendedIndexTypes fromString(String value) {
        RecommendedIndexTypes[] items = RecommendedIndexTypes.values();
        for (RecommendedIndexTypes item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
