/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ReplicationState.
 */
public final class ReplicationState {
    /** Static value PENDING for ReplicationState. */
    public static final ReplicationState PENDING = new ReplicationState("PENDING");

    /** Static value SEEDING for ReplicationState. */
    public static final ReplicationState SEEDING = new ReplicationState("SEEDING");

    /** Static value CATCH_UP for ReplicationState. */
    public static final ReplicationState CATCH_UP = new ReplicationState("CATCH_UP");

    /** Static value SUSPENDED for ReplicationState. */
    public static final ReplicationState SUSPENDED = new ReplicationState("SUSPENDED");

    private String value;

    /**
     * Creates a custom value for ReplicationState.
     * @param value the custom value
     */
    public ReplicationState(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ReplicationState)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ReplicationState rhs = (ReplicationState) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
