/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ServiceObjectiveName.
 */
public final class ServiceObjectiveName {
    /** Static value Basic for ServiceObjectiveName. */
    public static final ServiceObjectiveName BASIC = new ServiceObjectiveName("Basic");

    /** Static value S0 for ServiceObjectiveName. */
    public static final ServiceObjectiveName S0 = new ServiceObjectiveName("S0");

    /** Static value S1 for ServiceObjectiveName. */
    public static final ServiceObjectiveName S1 = new ServiceObjectiveName("S1");

    /** Static value S2 for ServiceObjectiveName. */
    public static final ServiceObjectiveName S2 = new ServiceObjectiveName("S2");

    /** Static value S3 for ServiceObjectiveName. */
    public static final ServiceObjectiveName S3 = new ServiceObjectiveName("S3");

    /** Static value P1 for ServiceObjectiveName. */
    public static final ServiceObjectiveName P1 = new ServiceObjectiveName("P1");

    /** Static value P2 for ServiceObjectiveName. */
    public static final ServiceObjectiveName P2 = new ServiceObjectiveName("P2");

    /** Static value P3 for ServiceObjectiveName. */
    public static final ServiceObjectiveName P3 = new ServiceObjectiveName("P3");

    private String value;

    /**
     * Creates a custom value for ServiceObjectiveName.
     * @param value the custom value
     */
    public ServiceObjectiveName(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceObjectiveName)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ServiceObjectiveName rhs = (ServiceObjectiveName) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
