/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.TableType;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * Represents an Azure SQL Database table.
 */
@JsonFlatten
public class TableInner extends Resource {
    /**
     * The type of Azure SQL Database table. Possible values include:
     * 'BaseTable', 'View'.
     */
    @JsonProperty(value = "properties.tableType", access = JsonProperty.Access.WRITE_ONLY)
    private TableType tableType;

    /**
     * The columns from this table.
     */
    @JsonProperty(value = "properties.columns", access = JsonProperty.Access.WRITE_ONLY)
    private List<ColumnInner> columns;

    /**
     * The recommended indices for this table.
     */
    @JsonProperty(value = "properties.recommendedIndexes", access = JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedIndexInner> recommendedIndexes;

    /**
     * Get the tableType value.
     *
     * @return the tableType value
     */
    public TableType tableType() {
        return this.tableType;
    }

    /**
     * Get the columns value.
     *
     * @return the columns value
     */
    public List<ColumnInner> columns() {
        return this.columns;
    }

    /**
     * Get the recommendedIndexes value.
     *
     * @return the recommendedIndexes value
     */
    public List<RecommendedIndexInner> recommendedIndexes() {
        return this.recommendedIndexes;
    }

}
