/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChild;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.ListToMapConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.sql.CreateMode;
import com.microsoft.azure.management.sql.DatabaseEditions;
import com.microsoft.azure.management.sql.DatabaseMetric;
import com.microsoft.azure.management.sql.ReplicationLink;
import com.microsoft.azure.management.sql.RestorePoint;
import com.microsoft.azure.management.sql.ServiceObjectiveName;
import com.microsoft.azure.management.sql.ServiceTierAdvisor;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlElasticPool;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlWarehouse;
import com.microsoft.azure.management.sql.TransparentDataEncryption;
import com.microsoft.azure.management.sql.UpgradeHintInterface;
import com.microsoft.azure.management.sql.implementation.DatabaseInner;
import com.microsoft.azure.management.sql.implementation.DatabaseMetricImpl;
import com.microsoft.azure.management.sql.implementation.DatabaseMetricInner;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkImpl;
import com.microsoft.azure.management.sql.implementation.ReplicationLinkInner;
import com.microsoft.azure.management.sql.implementation.RestorePointImpl;
import com.microsoft.azure.management.sql.implementation.RestorePointInner;
import com.microsoft.azure.management.sql.implementation.ServiceTierAdvisorImpl;
import com.microsoft.azure.management.sql.implementation.ServiceTierAdvisorInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.TransparentDataEncryptionImpl;
import com.microsoft.azure.management.sql.implementation.UpgradeHintImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlDatabaseImpl
extends IndependentChildResourceImpl<SqlDatabase, SqlServer, DatabaseInner, SqlDatabaseImpl, SqlServerManager>
implements SqlDatabase,
SqlDatabase.Definition,
SqlDatabase.DefinitionStages.WithCreateWithElasticPoolOptions,
SqlDatabase.DefinitionStages.WithExistingDatabase,
SqlDatabase.Update,
IndependentChild.DefinitionStages.WithParentResource<SqlDatabase, SqlServer> {
    private String elasticPoolCreatableKey;

    protected SqlDatabaseImpl(String name, DatabaseInner innerObject, SqlServerManager manager) {
        super(name, (Resource)innerObject, (Object)manager);
    }

    @Override
    public String sqlServerName() {
        return this.parentName;
    }

    @Override
    public String collation() {
        return ((DatabaseInner)((Object)this.inner())).collation();
    }

    @Override
    public DateTime creationDate() {
        return ((DatabaseInner)((Object)this.inner())).creationDate();
    }

    @Override
    public UUID currentServiceObjectiveId() {
        return ((DatabaseInner)((Object)this.inner())).currentServiceObjectiveId();
    }

    @Override
    public String databaseId() {
        return ((DatabaseInner)((Object)this.inner())).databaseId();
    }

    @Override
    public DateTime earliestRestoreDate() {
        return ((DatabaseInner)((Object)this.inner())).earliestRestoreDate();
    }

    @Override
    public DatabaseEditions edition() {
        return ((DatabaseInner)((Object)this.inner())).edition();
    }

    @Override
    public UUID requestedServiceObjectiveId() {
        return ((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveId();
    }

    @Override
    public long maxSizeBytes() {
        return Long.parseLong(((DatabaseInner)((Object)this.inner())).maxSizeBytes());
    }

    @Override
    public ServiceObjectiveName requestedServiceObjectiveName() {
        return ((DatabaseInner)((Object)this.inner())).requestedServiceObjectiveName();
    }

    @Override
    public ServiceObjectiveName serviceLevelObjective() {
        return ((DatabaseInner)((Object)this.inner())).serviceLevelObjective();
    }

    @Override
    public String status() {
        return ((DatabaseInner)((Object)this.inner())).status();
    }

    @Override
    public String elasticPoolName() {
        return ((DatabaseInner)((Object)this.inner())).elasticPoolName();
    }

    @Override
    public String defaultSecondaryLocation() {
        return ((DatabaseInner)((Object)this.inner())).defaultSecondaryLocation();
    }

    @Override
    public UpgradeHintInterface getUpgradeHint() {
        if (((DatabaseInner)((Object)this.inner())).upgradeHint() == null) {
            this.setInner((Object)((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().get(this.resourceGroupName(), this.sqlServerName(), this.name(), "upgradeHint"));
        }
        if (((DatabaseInner)((Object)this.inner())).upgradeHint() != null) {
            return new UpgradeHintImpl(((DatabaseInner)((Object)this.inner())).upgradeHint());
        }
        return null;
    }

    @Override
    public boolean isDataWarehouse() {
        return this.edition().toString().equalsIgnoreCase(DatabaseEditions.DATA_WAREHOUSE.toString());
    }

    @Override
    public SqlWarehouse asWarehouse() {
        if (this.isDataWarehouse()) {
            return (SqlWarehouse)((Object)this);
        }
        return null;
    }

    @Override
    public List<RestorePoint> listRestorePoints() {
        PagedListConverter<RestorePointInner, RestorePoint> converter = new PagedListConverter<RestorePointInner, RestorePoint>(){

            public RestorePoint typeConvert(RestorePointInner restorePointInner) {
                return new RestorePointImpl(restorePointInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().listRestorePoints(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public List<DatabaseMetric> listUsages() {
        PagedListConverter<DatabaseMetricInner, DatabaseMetric> converter = new PagedListConverter<DatabaseMetricInner, DatabaseMetric>(){

            public DatabaseMetric typeConvert(DatabaseMetricInner databaseMetricInner) {
                return new DatabaseMetricImpl(databaseMetricInner);
            }
        };
        return converter.convert(ReadableWrappersImpl.convertToPagedList(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().listUsages(this.resourceGroupName(), this.sqlServerName(), this.name())));
    }

    @Override
    public TransparentDataEncryption getTransparentDataEncryption() {
        return new TransparentDataEncryptionImpl(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().getTransparentDataEncryptionConfiguration(this.resourceGroupName(), this.sqlServerName(), this.name()), ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases());
    }

    @Override
    public Map<String, ServiceTierAdvisor> listServiceTierAdvisors() {
        final SqlDatabaseImpl self = this;
        ListToMapConverter<ServiceTierAdvisor, ServiceTierAdvisorInner> converter = new ListToMapConverter<ServiceTierAdvisor, ServiceTierAdvisorInner>(){

            protected String name(ServiceTierAdvisorInner serviceTierAdvisorInner) {
                return serviceTierAdvisorInner.name();
            }

            protected ServiceTierAdvisor impl(ServiceTierAdvisorInner serviceTierAdvisorInner) {
                return new ServiceTierAdvisorImpl(serviceTierAdvisorInner, ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)self.manager())).inner())).databases());
            }
        };
        return converter.convertToUnmodifiableMap(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().listServiceTierAdvisors(this.resourceGroupName(), this.sqlServerName(), this.name()));
    }

    @Override
    public Map<String, ReplicationLink> listReplicationLinks() {
        final SqlDatabaseImpl self = this;
        ListToMapConverter<ReplicationLink, ReplicationLinkInner> converter = new ListToMapConverter<ReplicationLink, ReplicationLinkInner>(){

            protected String name(ReplicationLinkInner replicationLinkInner) {
                return replicationLinkInner.name();
            }

            protected ReplicationLink impl(ReplicationLinkInner replicationLinkInner) {
                return new ReplicationLinkImpl(replicationLinkInner, ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)self.manager())).inner())).databases());
            }
        };
        return converter.convertToUnmodifiableMap(((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().listReplicationLinks(this.resourceGroupName(), this.sqlServerName(), this.name()));
    }

    @Override
    public void delete() {
        ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().delete(this.resourceGroupName(), this.sqlServerName(), this.name());
    }

    protected Observable<DatabaseInner> getInnerAsync() {
        if (((DatabaseInner)((Object)this.inner())).upgradeHint() != null) {
            return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name());
        }
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().getAsync(this.resourceGroupName(), this.sqlServerName(), this.name(), "upgradeHint");
    }

    protected Observable<SqlDatabase> createChildResourceAsync() {
        final SqlDatabaseImpl self = this;
        if (this.elasticPoolCreatableKey != null) {
            SqlElasticPool sqlElasticPool = (SqlElasticPool)this.createdResource(this.elasticPoolCreatableKey);
            this.withExistingElasticPool(sqlElasticPool);
        }
        if (((DatabaseInner)((Object)this.inner())).elasticPoolName() != null && !((DatabaseInner)((Object)this.inner())).elasticPoolName().isEmpty()) {
            ((DatabaseInner)((Object)this.inner())).withEdition(new DatabaseEditions(""));
            ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(new ServiceObjectiveName(""));
            ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        }
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)this.manager())).inner())).databases().createOrUpdateAsync(this.resourceGroupName(), this.sqlServerName(), this.name(), (DatabaseInner)((Object)this.inner())).map((Func1)new Func1<DatabaseInner, SqlDatabase>(){

            public SqlDatabase call(DatabaseInner databaseInner) {
                SqlDatabaseImpl.this.setInner((Object)databaseInner);
                self.elasticPoolCreatableKey = null;
                return self;
            }
        });
    }

    @Override
    public SqlDatabaseImpl withCollation(String collation) {
        ((DatabaseInner)((Object)this.inner())).withCollation(collation);
        return this;
    }

    @Override
    public SqlDatabaseImpl withEdition(DatabaseEditions edition) {
        ((DatabaseInner)((Object)this.inner())).withEdition(edition);
        return this;
    }

    @Override
    public SqlDatabaseImpl withoutElasticPool() {
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName("");
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(String elasticPoolName) {
        ((DatabaseInner)((Object)this.inner())).withElasticPoolName(elasticPoolName);
        return this;
    }

    @Override
    public SqlDatabaseImpl withExistingElasticPool(SqlElasticPool sqlElasticPool) {
        return this.withExistingElasticPool(sqlElasticPool.name());
    }

    @Override
    public SqlDatabaseImpl withNewElasticPool(Creatable<SqlElasticPool> sqlElasticPool) {
        if (this.elasticPoolCreatableKey == null) {
            this.elasticPoolCreatableKey = sqlElasticPool.key();
            this.addCreatableDependency(sqlElasticPool);
        }
        return this;
    }

    @Override
    public SqlDatabaseImpl withMaxSizeBytes(long maxSizeBytes) {
        ((DatabaseInner)((Object)this.inner())).withMaxSizeBytes(Long.toString(maxSizeBytes));
        return this;
    }

    @Override
    public SqlDatabaseImpl withServiceObjective(ServiceObjectiveName serviceLevelObjective) {
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveName(serviceLevelObjective);
        ((DatabaseInner)((Object)this.inner())).withRequestedServiceObjectiveId(null);
        return this;
    }

    @Override
    public SqlDatabaseImpl withMode(CreateMode createMode) {
        ((DatabaseInner)((Object)this.inner())).withCreateMode(createMode);
        return this;
    }

    @Override
    public SqlDatabase.DefinitionStages.WithCreateMode withSourceDatabase(String sourceDatabaseId) {
        ((DatabaseInner)((Object)this.inner())).withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    @Override
    public SqlDatabase.DefinitionStages.WithCreateMode withSourceDatabase(SqlDatabase sourceDatabase) {
        return this.withSourceDatabase(sourceDatabase.id());
    }
}

