/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.InstanceFailoverGroupReadWriteEndpoint;
import com.microsoft.azure.management.sql.InstanceFailoverGroupReadOnlyEndpoint;
import com.microsoft.azure.management.sql.InstanceFailoverGroupReplicationRole;
import java.util.List;
import com.microsoft.azure.management.sql.PartnerRegionInfo;
import com.microsoft.azure.management.sql.ManagedInstancePairInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * An instance failover group.
 */
@JsonFlatten
public class InstanceFailoverGroupInner extends ProxyResource {
    /**
     * Read-write endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readWriteEndpoint", required = true)
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;

    /**
     * Read-only endpoint of the failover group instance.
     */
    @JsonProperty(value = "properties.readOnlyEndpoint")
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;

    /**
     * Local replication role of the failover group instance. Possible values
     * include: 'Primary', 'Secondary'.
     */
    @JsonProperty(value = "properties.replicationRole", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceFailoverGroupReplicationRole replicationRole;

    /**
     * Replication state of the failover group instance.
     */
    @JsonProperty(value = "properties.replicationState", access = JsonProperty.Access.WRITE_ONLY)
    private String replicationState;

    /**
     * Partner region information for the failover group.
     */
    @JsonProperty(value = "properties.partnerRegions", required = true)
    private List<PartnerRegionInfo> partnerRegions;

    /**
     * List of managed instance pairs in the failover group.
     */
    @JsonProperty(value = "properties.managedInstancePairs", required = true)
    private List<ManagedInstancePairInfo> managedInstancePairs;

    /**
     * Get read-write endpoint of the failover group instance.
     *
     * @return the readWriteEndpoint value
     */
    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    /**
     * Set read-write endpoint of the failover group instance.
     *
     * @param readWriteEndpoint the readWriteEndpoint value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    /**
     * Get read-only endpoint of the failover group instance.
     *
     * @return the readOnlyEndpoint value
     */
    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    /**
     * Set read-only endpoint of the failover group instance.
     *
     * @param readOnlyEndpoint the readOnlyEndpoint value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    /**
     * Get local replication role of the failover group instance. Possible values include: 'Primary', 'Secondary'.
     *
     * @return the replicationRole value
     */
    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Get replication state of the failover group instance.
     *
     * @return the replicationState value
     */
    public String replicationState() {
        return this.replicationState;
    }

    /**
     * Get partner region information for the failover group.
     *
     * @return the partnerRegions value
     */
    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    /**
     * Set partner region information for the failover group.
     *
     * @param partnerRegions the partnerRegions value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    /**
     * Get list of managed instance pairs in the failover group.
     *
     * @return the managedInstancePairs value
     */
    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    /**
     * Set list of managed instance pairs in the failover group.
     *
     * @param managedInstancePairs the managedInstancePairs value to set
     * @return the InstanceFailoverGroupInner object itself.
     */
    public InstanceFailoverGroupInner withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

}
