/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for VulnerabilityAssessmentScanState.
 */
public final class VulnerabilityAssessmentScanState extends ExpandableStringEnum<VulnerabilityAssessmentScanState> {
    /** Static value Passed for VulnerabilityAssessmentScanState. */
    public static final VulnerabilityAssessmentScanState PASSED = fromString("Passed");

    /** Static value Failed for VulnerabilityAssessmentScanState. */
    public static final VulnerabilityAssessmentScanState FAILED = fromString("Failed");

    /** Static value FailedToRun for VulnerabilityAssessmentScanState. */
    public static final VulnerabilityAssessmentScanState FAILED_TO_RUN = fromString("FailedToRun");

    /** Static value InProgress for VulnerabilityAssessmentScanState. */
    public static final VulnerabilityAssessmentScanState IN_PROGRESS = fromString("InProgress");

    /**
     * Creates or finds a VulnerabilityAssessmentScanState from its string representation.
     * @param name a name to look for
     * @return the corresponding VulnerabilityAssessmentScanState
     */
    @JsonCreator
    public static VulnerabilityAssessmentScanState fromString(String name) {
        return fromString(name, VulnerabilityAssessmentScanState.class);
    }

    /**
     * @return known VulnerabilityAssessmentScanState values
     */
    public static Collection<VulnerabilityAssessmentScanState> values() {
        return values(VulnerabilityAssessmentScanState.class);
    }
}
