/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.sql.InstancePoolUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in InstancePools.
 */
public class InstancePoolsInner implements InnerSupportsGet<InstancePoolInner>, InnerSupportsDelete<Void>, InnerSupportsListing<InstancePoolInner> {
    /** The Retrofit service to perform REST calls. */
    private InstancePoolsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of InstancePoolsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public InstancePoolsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(InstancePoolsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for InstancePools to be
     * used by Retrofit to perform actually REST calls.
     */
    interface InstancePoolsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Body InstancePoolInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Body InstancePoolInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body InstancePoolUpdate parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("instancePoolName") String instancePoolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Body InstancePoolUpdate parameters, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Sql/instancePools")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.InstancePools listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner getByResourceGroup(String resourceGroupName, String instancePoolName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single().body();
    }

    /**
     * Gets an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be retrieved.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> getByResourceGroupAsync(String resourceGroupName, String instancePoolName, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    /**
     * Gets an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<InstancePoolInner> getByResourceGroupAsync(String resourceGroupName, String instancePoolName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, instancePoolName).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<ServiceResponse<InstancePoolInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.getByResourceGroup(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>() {
                @Override
                public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstancePoolInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstancePoolInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstancePoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstancePoolInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner createOrUpdate(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> createOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstancePoolInner> createOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstancePoolInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-06-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>() { }.getType());
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner beginCreateOrUpdate(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters), serviceCallback);
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<InstancePoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, parameters).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be created or updated.
     * @param parameters The requested instance pool resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<ServiceResponse<InstancePoolInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, InstancePoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2018-06-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>() {
                @Override
                public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstancePoolInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstancePoolInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstancePoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstancePoolInner>() { }.getType())
                .register(201, new TypeToken<InstancePoolInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String instancePoolName) {
        deleteWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().last().body();
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String instancePoolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String instancePoolName) {
        return deleteWithServiceResponseAsync(resourceGroupName, instancePoolName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String instancePoolName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single().body();
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String instancePoolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String instancePoolName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, instancePoolName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be deleted
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.beginDelete(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner update(String resourceGroupName, String instancePoolName) {
        return updateWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().last().body();
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName) {
        return updateWithServiceResponseAsync(resourceGroupName, instancePoolName).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstancePoolInner>> updateWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        final Map<String, String> tags = null;
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>() { }.getType());
    }
    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner update(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).toBlocking().last().body();
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags), serviceCallback);
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<InstancePoolInner> updateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return updateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<InstancePoolInner>> updateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2018-06-01-preview";
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<InstancePoolInner>() { }.getType());
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner beginUpdate(String resourceGroupName, String instancePoolName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName).toBlocking().single().body();
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName), serviceCallback);
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<ServiceResponse<InstancePoolInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        final Map<String, String> tags = null;
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(null);
        return service.beginUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>() {
                @Override
                public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstancePoolInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the InstancePoolInner object if successful.
     */
    public InstancePoolInner beginUpdate(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).toBlocking().single().body();
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags, final ServiceCallback<InstancePoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags), serviceCallback);
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<InstancePoolInner> beginUpdateAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, instancePoolName, tags).map(new Func1<ServiceResponse<InstancePoolInner>, InstancePoolInner>() {
            @Override
            public InstancePoolInner call(ServiceResponse<InstancePoolInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates an instance pool.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param instancePoolName The name of the instance pool to be updated.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the InstancePoolInner object
     */
    public Observable<ServiceResponse<InstancePoolInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String instancePoolName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (instancePoolName == null) {
            throw new IllegalArgumentException("Parameter instancePoolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        final String apiVersion = "2018-06-01-preview";
        InstancePoolUpdate parameters = new InstancePoolUpdate();
        parameters.withTags(tags);
        return service.beginUpdate(resourceGroupName, instancePoolName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), parameters, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<InstancePoolInner>>>() {
                @Override
                public Observable<ServiceResponse<InstancePoolInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<InstancePoolInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<InstancePoolInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<InstancePoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<InstancePoolInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstancePoolInner&gt; object if successful.
     */
    public PagedList<InstancePoolInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<InstancePoolInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<InstancePoolInner>(response.body()) {
            @Override
            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstancePoolInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<Page<InstancePoolInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>() {
                @Override
                public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
    ServiceResponse<PageImpl1<InstancePoolInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstancePoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstancePoolInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstancePoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstancePoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstancePoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstancePoolInner&gt; object if successful.
     */
    public PagedList<InstancePoolInner> list() {
        ServiceResponse<Page<InstancePoolInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<InstancePoolInner>(response.body()) {
            @Override
            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstancePoolInner>> listAsync(final ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<Page<InstancePoolInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>() {
                @Override
                public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstancePoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstancePoolInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstancePoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstancePoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstancePoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstancePoolInner&gt; object if successful.
     */
    public PagedList<InstancePoolInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<InstancePoolInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstancePoolInner>(response.body()) {
            @Override
            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstancePoolInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<InstancePoolInner>> serviceFuture, final ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<Page<InstancePoolInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>() {
                @Override
                public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of instance pools in the resource group.
     *
    ServiceResponse<PageImpl1<InstancePoolInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstancePoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstancePoolInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstancePoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstancePoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstancePoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;InstancePoolInner&gt; object if successful.
     */
    public PagedList<InstancePoolInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<InstancePoolInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<InstancePoolInner>(response.body()) {
            @Override
            public Page<InstancePoolInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<InstancePoolInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<InstancePoolInner>> serviceFuture, final ListOperationCallback<InstancePoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<Page<InstancePoolInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<InstancePoolInner>>, Page<InstancePoolInner>>() {
                @Override
                public Page<InstancePoolInner> call(ServiceResponse<Page<InstancePoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;InstancePoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<InstancePoolInner>>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(ServiceResponse<Page<InstancePoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of all instance pools in the subscription.
     *
    ServiceResponse<PageImpl1<InstancePoolInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;InstancePoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<InstancePoolInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<InstancePoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<InstancePoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<InstancePoolInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<InstancePoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<InstancePoolInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<InstancePoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<InstancePoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
