/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.SqlSyncFullSchemaProperty;
import com.microsoft.azure.management.sql.SqlSyncGroupLogProperty;
import com.microsoft.azure.management.sql.SqlSyncMemberOperations;
import com.microsoft.azure.management.sql.SyncConflictResolutionPolicy;
import com.microsoft.azure.management.sql.SyncGroupSchema;
import com.microsoft.azure.management.sql.SyncGroupState;
import com.microsoft.azure.management.sql.implementation.SyncGroupInner;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_9_0)
public interface SqlSyncGroup
extends ExternalChildResource<SqlSyncGroup, SqlDatabase>,
HasInner<SyncGroupInner>,
HasResourceGroup,
Refreshable<SqlSyncGroup>,
Updatable<Update> {
    public String sqlServerName();

    public String sqlDatabaseName();

    public String parentId();

    public int interval();

    public DateTime lastSyncTime();

    public SyncConflictResolutionPolicy conflictResolutionPolicy();

    public String syncDatabaseId();

    public String databaseUserName();

    public SyncGroupState syncState();

    public SyncGroupSchema schema();

    @Method
    public void delete();

    @Method
    public Completable deleteAsync();

    @Method
    public void refreshHubSchema();

    @Method
    public Completable refreshHubSchemaAsync();

    @Method
    public PagedList<SqlSyncFullSchemaProperty> listHubSchemas();

    @Method
    public Observable<SqlSyncFullSchemaProperty> listHubSchemasAsync();

    public PagedList<SqlSyncGroupLogProperty> listLogs(String var1, String var2, String var3);

    public Observable<SqlSyncGroupLogProperty> listLogsAsync(String var1, String var2, String var3);

    @Method
    public void triggerSynchronization();

    @Method
    public Completable triggerSynchronizationAsync();

    @Method
    public void cancelSynchronization();

    @Method
    public Completable cancelSynchronizationAsync();

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMembers();

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public static interface UpdateStages {

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithInterval {
            public Update withInterval(int var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithConflictResolutionPolicy {
            @Method
            public Update withConflictResolutionPolicyHubWins();

            @Method
            public Update withConflictResolutionPolicyMemberWins();
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithSchema {
            public Update withSchema(SyncGroupSchema var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithDatabasePassword {
            public Update withDatabasePassword(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithDatabaseUserName {
            public Update withDatabaseUserName(String var1);
        }

        @Beta(value=Beta.SinceVersion.V1_9_0)
        public static interface WithSyncDatabaseId {
            public Update withSyncDatabaseId(String var1);
        }
    }

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public static interface Update
    extends UpdateStages.WithSyncDatabaseId,
    UpdateStages.WithDatabaseUserName,
    UpdateStages.WithDatabasePassword,
    UpdateStages.WithConflictResolutionPolicy,
    UpdateStages.WithInterval,
    UpdateStages.WithSchema,
    Appliable<SqlSyncGroup> {
    }
}

