/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.DatabaseVulnerabilityAssessmentScansExportInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.VulnerabilityAssessmentScanRecordInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseVulnerabilityAssessmentScansInner {
    private DatabaseVulnerabilityAssessmentScansService service;
    private SqlManagementClientImpl client;

    public DatabaseVulnerabilityAssessmentScansInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentScansService)retrofit.create(DatabaseVulnerabilityAssessmentScansService.class);
        this.client = client;
    }

    public PagedList<VulnerabilityAssessmentScanRecordInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<VulnerabilityAssessmentScanRecordInner>((Page)response.body()){

            public Page<VulnerabilityAssessmentScanRecordInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ListOperationCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(String nextPageLink) {
                return DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VulnerabilityAssessmentScanRecordInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Page<VulnerabilityAssessmentScanRecordInner>>(){

            public Page<VulnerabilityAssessmentScanRecordInner> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VulnerabilityAssessmentScanRecordInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VulnerabilityAssessmentScanRecordInner get(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return (VulnerabilityAssessmentScanRecordInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single()).body());
    }

    public ServiceFuture<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, String databaseName, String scanId, ServiceCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    public Observable<VulnerabilityAssessmentScanRecordInner> getAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map((Func1)new Func1<ServiceResponse<VulnerabilityAssessmentScanRecordInner>, VulnerabilityAssessmentScanRecordInner>(){

            public VulnerabilityAssessmentScanRecordInner call(ServiceResponse<VulnerabilityAssessmentScanRecordInner> response) {
                return (VulnerabilityAssessmentScanRecordInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, "default", scanId, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>>>(){

            public Observable<ServiceResponse<VulnerabilityAssessmentScanRecordInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentScansInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VulnerabilityAssessmentScanRecordInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VulnerabilityAssessmentScanRecordInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void initiateScan(String resourceGroupName, String serverName, String databaseName, String scanId) {
        ((ServiceResponse)this.initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().last()).body();
    }

    public ServiceFuture<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    public Observable<Void> initiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return this.initiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> initiateScanWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.initiateScan(resourceGroupName, serverName, databaseName, "default", scanId, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginInitiateScan(String resourceGroupName, String serverName, String databaseName, String scanId) {
        ((ServiceResponse)this.beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    public Observable<Void> beginInitiateScanAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return this.beginInitiateScanWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginInitiateScanWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.beginInitiateScan(resourceGroupName, serverName, databaseName, "default", scanId, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentScansInner.this.beginInitiateScanDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginInitiateScanDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseVulnerabilityAssessmentScansExportInner export(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return (DatabaseVulnerabilityAssessmentScansExportInner)((Object)((ServiceResponse)this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).toBlocking().single()).body());
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String serverName, String databaseName, String scanId, ServiceCallback<DatabaseVulnerabilityAssessmentScansExportInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentScansExportInner> exportAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        return this.exportWithServiceResponseAsync(resourceGroupName, serverName, databaseName, scanId).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>, DatabaseVulnerabilityAssessmentScansExportInner>(){

            public DatabaseVulnerabilityAssessmentScansExportInner call(ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner> response) {
                return (DatabaseVulnerabilityAssessmentScansExportInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>> exportWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, String scanId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (scanId == null) {
            throw new IllegalArgumentException("Parameter scanId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.export(resourceGroupName, serverName, databaseName, "default", scanId, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentScansInner.this.exportDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentScansExportInner> exportDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentScansExportInner>(){}.getType()).register(201, new TypeToken<DatabaseVulnerabilityAssessmentScansExportInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VulnerabilityAssessmentScanRecordInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VulnerabilityAssessmentScanRecordInner>((Page)response.body()){

            public Page<VulnerabilityAssessmentScanRecordInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<VulnerabilityAssessmentScanRecordInner>> serviceFuture, ListOperationCallback<VulnerabilityAssessmentScanRecordInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(String nextPageLink) {
                return DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Page<VulnerabilityAssessmentScanRecordInner>>(){

            public Page<VulnerabilityAssessmentScanRecordInner> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>>>(){

            public Observable<ServiceResponse<Page<VulnerabilityAssessmentScanRecordInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = DatabaseVulnerabilityAssessmentScansInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VulnerabilityAssessmentScanRecordInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VulnerabilityAssessmentScanRecordInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseVulnerabilityAssessmentScansService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="scanId") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans initiateScan"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        public Observable<Response<ResponseBody>> initiateScan(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="scanId") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans beginInitiateScan"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan")
        public Observable<Response<ResponseBody>> beginInitiateScan(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="scanId") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans export"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export")
        public Observable<Response<ResponseBody>> export(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="scanId") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessmentScans listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

