/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Elastic Pool DTU capability.
 */
public class ElasticPoolDtuCapability {
    /**
     * The maximum size of the database (see 'unit' for the units).
     */
    @JsonProperty(value = "limit", access = JsonProperty.Access.WRITE_ONLY)
    private Long limit;

    /**
     * The maximum number of databases supported.
     */
    @JsonProperty(value = "maxDatabaseCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long maxDatabaseCount;

    /**
     * The status of the capability. Possible values include: 'Visible',
     * 'Available', 'Default', 'Disabled'.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private CapabilityStatus status;

    /**
     * The list of supported max sizes.
     */
    @JsonProperty(value = "supportedMaxSizes", access = JsonProperty.Access.WRITE_ONLY)
    private List<MaxSizeCapability> supportedMaxSizes;

    /**
     * The included (free) max size for this service level objective.
     */
    @JsonProperty(value = "includedMaxSize", access = JsonProperty.Access.WRITE_ONLY)
    private MaxSizeCapability includedMaxSize;

    /**
     * The list of supported max database sizes.
     */
    @JsonProperty(value = "supportedPerDatabaseMaxSizes", access = JsonProperty.Access.WRITE_ONLY)
    private List<MaxSizeCapability> supportedPerDatabaseMaxSizes;

    /**
     * The list of supported max database DTUs.
     */
    @JsonProperty(value = "supportedPerDatabaseMaxDtus", access = JsonProperty.Access.WRITE_ONLY)
    private List<ElasticPoolPerDatabaseMaxDtuCapability> supportedPerDatabaseMaxDtus;

    /**
     * Get the maximum size of the database (see 'unit' for the units).
     *
     * @return the limit value
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Get the maximum number of databases supported.
     *
     * @return the maxDatabaseCount value
     */
    public Long maxDatabaseCount() {
        return this.maxDatabaseCount;
    }

    /**
     * Get the status of the capability. Possible values include: 'Visible', 'Available', 'Default', 'Disabled'.
     *
     * @return the status value
     */
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Get the list of supported max sizes.
     *
     * @return the supportedMaxSizes value
     */
    public List<MaxSizeCapability> supportedMaxSizes() {
        return this.supportedMaxSizes;
    }

    /**
     * Get the included (free) max size for this service level objective.
     *
     * @return the includedMaxSize value
     */
    public MaxSizeCapability includedMaxSize() {
        return this.includedMaxSize;
    }

    /**
     * Get the list of supported max database sizes.
     *
     * @return the supportedPerDatabaseMaxSizes value
     */
    public List<MaxSizeCapability> supportedPerDatabaseMaxSizes() {
        return this.supportedPerDatabaseMaxSizes;
    }

    /**
     * Get the list of supported max database DTUs.
     *
     * @return the supportedPerDatabaseMaxDtus value
     */
    public List<ElasticPoolPerDatabaseMaxDtuCapability> supportedPerDatabaseMaxDtus() {
        return this.supportedPerDatabaseMaxDtus;
    }

}
