/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.sql.VirtualClusterUpdate;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in VirtualClusters.
 */
public class VirtualClustersInner implements InnerSupportsGet<VirtualClusterInner>, InnerSupportsDelete<Void>, InnerSupportsListing<VirtualClusterInner> {
    /** The Retrofit service to perform REST calls. */
    private VirtualClustersService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of VirtualClustersInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public VirtualClustersInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(VirtualClustersService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for VirtualClusters to be
     * used by Retrofit to perform actually REST calls.
     */
    interface VirtualClustersService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters list" })
        @GET("subscriptions/{subscriptionId}/providers/Microsoft.Sql/virtualClusters")
        Observable<Response<ResponseBody>> list(@Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters")
        Observable<Response<ResponseBody>> listByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters getByResourceGroup" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        Observable<Response<ResponseBody>> getByResourceGroup(@Path("resourceGroupName") String resourceGroupName, @Path("virtualClusterName") String virtualClusterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualClusterName") String virtualClusterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("virtualClusterName") String virtualClusterName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("virtualClusterName") String virtualClusterName, @Path("subscriptionId") String subscriptionId, @Body VirtualClusterUpdate parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("virtualClusterName") String virtualClusterName, @Path("subscriptionId") String subscriptionId, @Body VirtualClusterUpdate parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listNext" })
        @GET
        Observable<Response<ResponseBody>> listNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listByResourceGroupNext" })
        @GET
        Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualClusterInner&gt; object if successful.
     */
    public PagedList<VirtualClusterInner> list() {
        ServiceResponse<Page<VirtualClusterInner>> response = listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualClusterInner>(response.body()) {
            @Override
            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualClusterInner>> listAsync(final ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listSinglePageAsync(),
            new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<Page<VirtualClusterInner>> listAsync() {
        return listWithServiceResponseAsync()
            .map(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>() {
                @Override
                public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listWithServiceResponseAsync() {
        return listSinglePageAsync()
            .concatMap(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.list(this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualClusterInner>> result = listDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualClusterInner&gt; object if successful.
     */
    public PagedList<VirtualClusterInner> listByResourceGroup(final String resourceGroupName) {
        ServiceResponse<Page<VirtualClusterInner>> response = listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualClusterInner>(response.body()) {
            @Override
            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualClusterInner>> listByResourceGroupAsync(final String resourceGroupName, final ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupSinglePageAsync(resourceGroupName),
            new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<Page<VirtualClusterInner>> listByResourceGroupAsync(final String resourceGroupName) {
        return listByResourceGroupWithServiceResponseAsync(resourceGroupName)
            .map(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>() {
                @Override
                public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupWithServiceResponseAsync(final String resourceGroupName) {
        return listByResourceGroupSinglePageAsync(resourceGroupName)
            .concatMap(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
    ServiceResponse<PageImpl1<VirtualClusterInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupSinglePageAsync(final String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualClusterInner>> result = listByResourceGroupDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualClusterInner object if successful.
     */
    public VirtualClusterInner getByResourceGroup(String resourceGroupName, String virtualClusterName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().single().body();
    }

    /**
     * Gets a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualClusterInner> getByResourceGroupAsync(String resourceGroupName, String virtualClusterName, final ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    /**
     * Gets a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualClusterInner object
     */
    public Observable<VirtualClusterInner> getByResourceGroupAsync(String resourceGroupName, String virtualClusterName) {
        return getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName).map(new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>() {
            @Override
            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualClusterInner object
     */
    public Observable<ServiceResponse<VirtualClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.getByResourceGroup(resourceGroupName, virtualClusterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualClusterInner> clientResponse = getByResourceGroupDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualClusterInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualClusterInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String virtualClusterName) {
        deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().last().body();
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualClusterName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String virtualClusterName) {
        return deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, virtualClusterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String virtualClusterName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().single().body();
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualClusterName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualClusterName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginDelete(resourceGroupName, virtualClusterName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualClusterInner object if successful.
     */
    public VirtualClusterInner update(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).toBlocking().last().body();
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualClusterInner> updateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters, final ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters), serviceCallback);
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<VirtualClusterInner> updateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).map(new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>() {
            @Override
            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<VirtualClusterInner>> updateWithServiceResponseAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, virtualClusterName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualClusterInner>() { }.getType());
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the VirtualClusterInner object if successful.
     */
    public VirtualClusterInner beginUpdate(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).toBlocking().single().body();
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<VirtualClusterInner> beginUpdateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters, final ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters), serviceCallback);
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualClusterInner object
     */
    public Observable<VirtualClusterInner> beginUpdateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).map(new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>() {
            @Override
            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a virtual cluster.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param virtualClusterName The name of the virtual cluster.
     * @param parameters The requested managed instance resource state.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the VirtualClusterInner object
     */
    public Observable<ServiceResponse<VirtualClusterInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        return service.beginUpdate(resourceGroupName, virtualClusterName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualClusterInner>>>() {
                @Override
                public Observable<ServiceResponse<VirtualClusterInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<VirtualClusterInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<VirtualClusterInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<VirtualClusterInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<VirtualClusterInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualClusterInner&gt; object if successful.
     */
    public PagedList<VirtualClusterInner> listNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualClusterInner>> response = listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualClusterInner>(response.body()) {
            @Override
            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return listNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualClusterInner>> listNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualClusterInner>> serviceFuture, final ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                    return listNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<Page<VirtualClusterInner>> listNextAsync(final String nextPageLink) {
        return listNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>() {
                @Override
                public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listNextWithServiceResponseAsync(final String nextPageLink) {
        return listNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of all virtualClusters in the subscription.
     *
    ServiceResponse<PageImpl1<VirtualClusterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualClusterInner>> result = listNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;VirtualClusterInner&gt; object if successful.
     */
    public PagedList<VirtualClusterInner> listByResourceGroupNext(final String nextPageLink) {
        ServiceResponse<Page<VirtualClusterInner>> response = listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualClusterInner>(response.body()) {
            @Override
            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<VirtualClusterInner>> listByResourceGroupNextAsync(final String nextPageLink, final ServiceFuture<List<VirtualClusterInner>> serviceFuture, final ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByResourceGroupNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                    return listByResourceGroupNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<Page<VirtualClusterInner>> listByResourceGroupNextAsync(final String nextPageLink) {
        return listByResourceGroupNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>() {
                @Override
                public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;VirtualClusterInner&gt; object
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(final String nextPageLink) {
        return listByResourceGroupNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of virtual clusters in a resource group.
     *
    ServiceResponse<PageImpl1<VirtualClusterInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;VirtualClusterInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<VirtualClusterInner>> result = listByResourceGroupNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<VirtualClusterInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<VirtualClusterInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<VirtualClusterInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
