/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ExternalChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.collection.SupportsCreating;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.sql.SecurityAlertPolicyState;
import com.microsoft.azure.management.sql.SqlDatabase;
import com.microsoft.azure.management.sql.implementation.DatabaseSecurityAlertPolicyInner;

@Fluent
@Beta(value=Beta.SinceVersion.V1_7_0)
public interface SqlDatabaseThreatDetectionPolicy
extends ExternalChildResource<SqlDatabaseThreatDetectionPolicy, SqlDatabase>,
HasParent<SqlDatabase>,
HasInner<DatabaseSecurityAlertPolicyInner>,
HasResourceGroup,
Refreshable<SqlDatabaseThreatDetectionPolicy>,
Updatable<Update> {
    public Region region();

    public String kind();

    public SecurityAlertPolicyState currentState();

    public String disabledAlerts();

    public String emailAddresses();

    public boolean emailAccountAdmins();

    public String storageEndpoint();

    public String storageAccountAccessKey();

    public int retentionDays();

    public boolean isDefaultSecurityAlertPolicy();

    public static interface UpdateStages {

        public static interface WithEmailToAccountAdmins {
            @Method
            public Update withEmailToAccountAdmins();

            @Method
            public Update withoutEmailToAccountAdmins();
        }

        public static interface WithRetentionDays {
            public Update withRetentionDays(int var1);
        }

        public static interface WithEmailAddresses {
            public Update withEmailAddresses(String var1);
        }

        public static interface WithAlertsFilter {
            public Update withAlertsFilter(String var1);
        }

        public static interface WithStorageAccountAccessKey {
            public Update withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public Update withStorageEndpoint(String var1);
        }

        public static interface WithSecurityAlertPolicyState {
            @Method
            public Update withPolicyEnabled();

            @Method
            public Update withPolicyDisabled();

            @Method
            public Update withPolicyNew();

            @Method
            public Update withDefaultSecurityAlertPolicy();
        }
    }

    public static interface Update
    extends UpdateStages.WithSecurityAlertPolicyState,
    UpdateStages.WithStorageEndpoint,
    UpdateStages.WithStorageAccountAccessKey,
    UpdateStages.WithAlertsFilter,
    UpdateStages.WithEmailAddresses,
    UpdateStages.WithRetentionDays,
    UpdateStages.WithEmailToAccountAdmins,
    Appliable<SqlDatabaseThreatDetectionPolicy> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithStorageEndpoint,
        WithStorageAccountAccessKey,
        WithAlertsFilter,
        WithEmailAddresses,
        WithRetentionDays,
        WithEmailToAccountAdmins,
        Creatable<SqlDatabaseThreatDetectionPolicy> {
        }

        public static interface WithEmailToAccountAdmins {
            @Method
            public WithCreate withEmailToAccountAdmins();

            @Method
            public WithCreate withoutEmailToAccountAdmins();
        }

        public static interface WithRetentionDays {
            public WithCreate withRetentionDays(int var1);
        }

        public static interface WithEmailAddresses {
            public WithCreate withEmailAddresses(String var1);
        }

        public static interface WithAlertsFilter {
            public WithCreate withAlertsFilter(String var1);
        }

        public static interface WithStorageAccountAccessKey {
            public WithCreate withStorageAccountAccessKey(String var1);
        }

        public static interface WithStorageEndpoint {
            public WithStorageAccountAccessKey withStorageEndpoint(String var1);
        }

        public static interface WithSecurityAlertPolicyState {
            @Method
            public WithStorageEndpoint withPolicyEnabled();

            @Method
            public WithCreate withPolicyDisabled();

            @Method
            public WithStorageEndpoint withPolicyNew();

            @Method
            public WithCreate withDefaultSecurityAlertPolicy();
        }

        public static interface Blank
        extends WithSecurityAlertPolicyState {
        }
    }

    public static interface SqlDatabaseThreatDetectionPolicyDefinition
    extends DefinitionStages.Blank,
    DefinitionStages.WithSecurityAlertPolicyState,
    DefinitionStages.WithStorageEndpoint,
    DefinitionStages.WithStorageAccountAccessKey,
    DefinitionStages.WithAlertsFilter,
    DefinitionStages.WithEmailAddresses,
    DefinitionStages.WithRetentionDays,
    DefinitionStages.WithEmailToAccountAdmins,
    DefinitionStages.WithCreate {
    }

    public static interface SqlDatabaseThreatDetectionPolicyOperations
    extends SupportsCreating<DefinitionStages.Blank> {
        public DefinitionStages.Blank defineThreatDetectionPolicy(String var1);

        @Method
        public SqlDatabaseThreatDetectionPolicy getThreatDetectionPolicy();
    }
}

