/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.FirewallRuleInner;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class FirewallRulesInner {
    private FirewallRulesService service;
    private SqlManagementClientImpl client;

    public FirewallRulesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (FirewallRulesService)retrofit.create(FirewallRulesService.class);
        this.client = client;
    }

    public FirewallRuleInner createOrUpdate(String resourceGroupName, String serverName, String firewallRuleName, FirewallRuleInner parameters) {
        return (FirewallRuleInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String firewallRuleName, FirewallRuleInner parameters, ServiceCallback<FirewallRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName, parameters), serviceCallback);
    }

    public Observable<FirewallRuleInner> createOrUpdateAsync(String resourceGroupName, String serverName, String firewallRuleName, FirewallRuleInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName, parameters).map((Func1)new Func1<ServiceResponse<FirewallRuleInner>, FirewallRuleInner>(){

            public FirewallRuleInner call(ServiceResponse<FirewallRuleInner> response) {
                return (FirewallRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallRuleInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String firewallRuleName, FirewallRuleInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2014-04-01";
        return this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, serverName, firewallRuleName, "2014-04-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRuleInner>>>(){

            public Observable<ServiceResponse<FirewallRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallRuleInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallRuleInner>(){}.getType()).register(201, new TypeToken<FirewallRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String firewallRuleName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String firewallRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String firewallRuleName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String firewallRuleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, serverName, firewallRuleName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FirewallRuleInner get(String resourceGroupName, String serverName, String firewallRuleName) {
        return (FirewallRuleInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallRuleInner> getAsync(String resourceGroupName, String serverName, String firewallRuleName, ServiceCallback<FirewallRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName), serviceCallback);
    }

    public Observable<FirewallRuleInner> getAsync(String resourceGroupName, String serverName, String firewallRuleName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, firewallRuleName).map((Func1)new Func1<ServiceResponse<FirewallRuleInner>, FirewallRuleInner>(){

            public FirewallRuleInner call(ServiceResponse<FirewallRuleInner> response) {
                return (FirewallRuleInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallRuleInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String firewallRuleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (firewallRuleName == null) {
            throw new IllegalArgumentException("Parameter firewallRuleName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, firewallRuleName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallRuleInner>>>(){

            public Observable<ServiceResponse<FirewallRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallRulesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallRuleInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallRuleInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<FirewallRuleInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<FirewallRuleInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<FirewallRuleInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<FirewallRuleInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<FirewallRuleInner>>, List<FirewallRuleInner>>(){

            public List<FirewallRuleInner> call(ServiceResponse<List<FirewallRuleInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<FirewallRuleInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<FirewallRuleInner>>>>(){

            public Observable<ServiceResponse<List<FirewallRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallRulesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallRuleInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallRuleInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FirewallRulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FirewallRules createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Body FirewallRuleInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FirewallRules delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FirewallRules get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="firewallRuleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FirewallRules listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

