/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * A backup long term retention vault.
 */
@JsonFlatten
public class BackupLongTermRetentionVaultInner extends ProxyResource {
    /**
     * The geo-location where the resource lives.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /**
     * The azure recovery services vault resource id.
     */
    @JsonProperty(value = "properties.recoveryServicesVaultResourceId", required = true)
    private String recoveryServicesVaultResourceId;

    /**
     * Get the geo-location where the resource lives.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the azure recovery services vault resource id.
     *
     * @return the recoveryServicesVaultResourceId value
     */
    public String recoveryServicesVaultResourceId() {
        return this.recoveryServicesVaultResourceId;
    }

    /**
     * Set the azure recovery services vault resource id.
     *
     * @param recoveryServicesVaultResourceId the recoveryServicesVaultResourceId value to set
     * @return the BackupLongTermRetentionVaultInner object itself.
     */
    public BackupLongTermRetentionVaultInner withRecoveryServicesVaultResourceId(String recoveryServicesVaultResourceId) {
        this.recoveryServicesVaultResourceId = recoveryServicesVaultResourceId;
        return this;
    }

}
