/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.Sku;
import com.microsoft.azure.management.sql.InstancePoolLicenseType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.Resource;

/**
 * An Azure SQL instance pool.
 */
@JsonFlatten
public class InstancePoolInner extends Resource {
    /**
     * The name and tier of the SKU.
     */
    @JsonProperty(value = "sku")
    private Sku sku;

    /**
     * Resource ID of the subnet to place this instance pool in.
     */
    @JsonProperty(value = "properties.subnetId", required = true)
    private String subnetId;

    /**
     * Count of vCores belonging to this instance pool.
     */
    @JsonProperty(value = "properties.vCores", required = true)
    private int vCores;

    /**
     * The license type. Possible values are 'LicenseIncluded' (price for SQL
     * license is included) and 'BasePrice' (without SQL license price).
     * Possible values include: 'LicenseIncluded', 'BasePrice'.
     */
    @JsonProperty(value = "properties.licenseType", required = true)
    private InstancePoolLicenseType licenseType;

    /**
     * Get the name and tier of the SKU.
     *
     * @return the sku value
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the name and tier of the SKU.
     *
     * @param sku the sku value to set
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get resource ID of the subnet to place this instance pool in.
     *
     * @return the subnetId value
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set resource ID of the subnet to place this instance pool in.
     *
     * @param subnetId the subnetId value to set
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Get count of vCores belonging to this instance pool.
     *
     * @return the vCores value
     */
    public int vCores() {
        return this.vCores;
    }

    /**
     * Set count of vCores belonging to this instance pool.
     *
     * @param vCores the vCores value to set
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withVCores(int vCores) {
        this.vCores = vCores;
        return this;
    }

    /**
     * Get the license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). Possible values include: 'LicenseIncluded', 'BasePrice'.
     *
     * @return the licenseType value
     */
    public InstancePoolLicenseType licenseType() {
        return this.licenseType;
    }

    /**
     * Set the license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price). Possible values include: 'LicenseIncluded', 'BasePrice'.
     *
     * @param licenseType the licenseType value to set
     * @return the InstancePoolInner object itself.
     */
    public InstancePoolInner withLicenseType(InstancePoolLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

}
