/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobsInner {
    private JobsService service;
    private SqlManagementClientImpl client;

    public JobsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobsService)retrofit.create(JobsService.class);
        this.client = client;
    }

    public PagedList<JobInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        ServiceResponse response = (ServiceResponse)this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByAgentWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName) {
        return this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByAgent(resourceGroupName, serverName, jobAgentName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByAgentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobInner>> listByAgentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return (JobInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    public Observable<JobInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, JobInner parameters) {
        return (JobInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, JobInner parameters, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, parameters), serviceCallback);
    }

    public Observable<JobInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, JobInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, parameters).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, JobInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).register(201, new TypeToken<JobInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> listByAgentNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByAgentNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByAgentNextAsync(String nextPageLink, ServiceFuture<List<JobInner>> serviceFuture, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByAgentNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByAgentNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByAgentNextAsync(String nextPageLink) {
        return this.listByAgentNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByAgentNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByAgentNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByAgentNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByAgentNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByAgentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByAgentNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobInner>> listByAgentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Jobs listByAgent"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs")
        public Observable<Response<ResponseBody>> listByAgent(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Jobs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Jobs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Body JobInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Jobs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.Jobs listByAgentNext"})
        @GET
        public Observable<Response<ResponseBody>> listByAgentNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

