/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ManagedInstanceVulnerabilityAssessments.
 */
public class ManagedInstanceVulnerabilityAssessmentsInner implements InnerSupportsDelete<Void> {
    /** The Retrofit service to perform REST calls. */
    private ManagedInstanceVulnerabilityAssessmentsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of ManagedInstanceVulnerabilityAssessmentsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ManagedInstanceVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(ManagedInstanceVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ManagedInstanceVulnerabilityAssessments to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ManagedInstanceVulnerabilityAssessmentsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Body ManagedInstanceVulnerabilityAssessmentInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("vulnerabilityAssessmentName") String vulnerabilityAssessmentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments listByInstance" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/vulnerabilityAssessments")
        Observable<Response<ResponseBody>> listByInstance(@Path("resourceGroupName") String resourceGroupName, @Path("managedInstanceName") String managedInstanceName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedInstanceVulnerabilityAssessments listByInstanceNext" })
        @GET
        Observable<Response<ResponseBody>> listByInstanceNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedInstanceVulnerabilityAssessmentInner object if successful.
     */
    public ManagedInstanceVulnerabilityAssessmentInner get(String resourceGroupName, String managedInstanceName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single().body();
    }

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedInstanceVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName, final ServiceCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceVulnerabilityAssessmentInner object
     */
    public Observable<ManagedInstanceVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String managedInstanceName) {
        return getWithServiceResponseAsync(resourceGroupName, managedInstanceName).map(new Func1<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>, ManagedInstanceVulnerabilityAssessmentInner>() {
            @Override
            public ManagedInstanceVulnerabilityAssessmentInner call(ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.get(resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedInstanceVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ManagedInstanceVulnerabilityAssessmentInner object if successful.
     */
    public ManagedInstanceVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters, final ServiceCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceVulnerabilityAssessmentInner object
     */
    public Observable<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map(new Func1<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>, ManagedInstanceVulnerabilityAssessmentInner>() {
            @Override
            public ManagedInstanceVulnerabilityAssessmentInner call(ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param parameters The requested resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ManagedInstanceVulnerabilityAssessmentInner object
     */
    public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedInstanceVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.createOrUpdate(resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>>>() {
                @Override
                public Observable<ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ManagedInstanceVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ManagedInstanceVulnerabilityAssessmentInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>() { }.getType())
                .register(201, new TypeToken<ManagedInstanceVulnerabilityAssessmentInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String managedInstanceName) {
        deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single().body();
    }

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String managedInstanceName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String managedInstanceName) {
        return deleteWithServiceResponseAsync(resourceGroupName, managedInstanceName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Removes the managed instance's vulnerability assessment.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String vulnerabilityAssessmentName = "default";
        final String apiVersion = "2018-06-01-preview";
        return service.delete(resourceGroupName, managedInstanceName, vulnerabilityAssessmentName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<ManagedInstanceVulnerabilityAssessmentInner> listByInstance(final String resourceGroupName, final String managedInstanceName) {
        ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response = listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedInstanceVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<ManagedInstanceVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName, final ListOperationCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName),
            new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName)
            .map(new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Page<ManagedInstanceVulnerabilityAssessmentInner>>() {
                @Override
                public Page<ManagedInstanceVulnerabilityAssessmentInner> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceWithServiceResponseAsync(final String resourceGroupName, final String managedInstanceName) {
        return listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName)
            .concatMap(new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
    ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> * @param managedInstanceName The name of the managed instance for which the vulnerability assessments is defined.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceSinglePageAsync(final String resourceGroupName, final String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2018-06-01-preview";
        return service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> result = listByInstanceDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object if successful.
     */
    public PagedList<ManagedInstanceVulnerabilityAssessmentInner> listByInstanceNext(final String nextPageLink) {
        ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response = listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedInstanceVulnerabilityAssessmentInner>(response.body()) {
            @Override
            public Page<ManagedInstanceVulnerabilityAssessmentInner> nextPage(String nextPageLink) {
                return listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextAsync(final String nextPageLink, final ServiceFuture<List<ManagedInstanceVulnerabilityAssessmentInner>> serviceFuture, final ListOperationCallback<ManagedInstanceVulnerabilityAssessmentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByInstanceNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(String nextPageLink) {
                    return listByInstanceNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object
     */
    public Observable<Page<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextAsync(final String nextPageLink) {
        return listByInstanceNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Page<ManagedInstanceVulnerabilityAssessmentInner>>() {
                @Override
                public Page<ManagedInstanceVulnerabilityAssessmentInner> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object
     */
    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceNextWithServiceResponseAsync(final String nextPageLink) {
        return listByInstanceNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByInstanceNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets the managed instance's vulnerability assessment policies.
     *
    ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;ManagedInstanceVulnerabilityAssessmentInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> listByInstanceNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> result = listByInstanceNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<ManagedInstanceVulnerabilityAssessmentInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<ManagedInstanceVulnerabilityAssessmentInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
