/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.management.sql.BlobAuditingPolicyState;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * A database blob auditing policy.
 */
@JsonFlatten
public class DatabaseBlobAuditingPolicyInner extends ProxyResourceInner {
    /**
     * Resource kind.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /**
     * Specifies the state of the policy. If state is Enabled, storageEndpoint
     * and storageAccountAccessKey are required. Possible values include:
     * 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.state", required = true)
    private BlobAuditingPolicyState state;

    /**
     * Specifies the blob storage endpoint (e.g.
     * https://MyAccount.blob.core.windows.net). If state is Enabled,
     * storageEndpoint is required.
     */
    @JsonProperty(value = "properties.storageEndpoint")
    private String storageEndpoint;

    /**
     * Specifies the identifier key of the auditing storage account. If state
     * is Enabled, storageAccountAccessKey is required.
     */
    @JsonProperty(value = "properties.storageAccountAccessKey")
    private String storageAccountAccessKey;

    /**
     * Specifies the number of days to keep in the audit logs.
     */
    @JsonProperty(value = "properties.retentionDays")
    private Integer retentionDays;

    /**
     * Specifies the Actions and Actions-Groups to audit.
     */
    @JsonProperty(value = "properties.auditActionsAndGroups")
    private List<String> auditActionsAndGroups;

    /**
     * Specifies the blob storage subscription Id.
     */
    @JsonProperty(value = "properties.storageAccountSubscriptionId")
    private UUID storageAccountSubscriptionId;

    /**
     * Specifies whether storageAccountAccessKey value is the storage’s
     * secondary key.
     */
    @JsonProperty(value = "properties.isStorageSecondaryKeyInUse")
    private Boolean isStorageSecondaryKeyInUse;

    /**
     * Get the kind value.
     *
     * @return the kind value
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the state value.
     *
     * @return the state value
     */
    public BlobAuditingPolicyState state() {
        return this.state;
    }

    /**
     * Set the state value.
     *
     * @param state the state value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withState(BlobAuditingPolicyState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the storageEndpoint value.
     *
     * @return the storageEndpoint value
     */
    public String storageEndpoint() {
        return this.storageEndpoint;
    }

    /**
     * Set the storageEndpoint value.
     *
     * @param storageEndpoint the storageEndpoint value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
        return this;
    }

    /**
     * Get the storageAccountAccessKey value.
     *
     * @return the storageAccountAccessKey value
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey value.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the retentionDays value.
     *
     * @return the retentionDays value
     */
    public Integer retentionDays() {
        return this.retentionDays;
    }

    /**
     * Set the retentionDays value.
     *
     * @param retentionDays the retentionDays value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withRetentionDays(Integer retentionDays) {
        this.retentionDays = retentionDays;
        return this;
    }

    /**
     * Get the auditActionsAndGroups value.
     *
     * @return the auditActionsAndGroups value
     */
    public List<String> auditActionsAndGroups() {
        return this.auditActionsAndGroups;
    }

    /**
     * Set the auditActionsAndGroups value.
     *
     * @param auditActionsAndGroups the auditActionsAndGroups value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withAuditActionsAndGroups(List<String> auditActionsAndGroups) {
        this.auditActionsAndGroups = auditActionsAndGroups;
        return this;
    }

    /**
     * Get the storageAccountSubscriptionId value.
     *
     * @return the storageAccountSubscriptionId value
     */
    public UUID storageAccountSubscriptionId() {
        return this.storageAccountSubscriptionId;
    }

    /**
     * Set the storageAccountSubscriptionId value.
     *
     * @param storageAccountSubscriptionId the storageAccountSubscriptionId value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withStorageAccountSubscriptionId(UUID storageAccountSubscriptionId) {
        this.storageAccountSubscriptionId = storageAccountSubscriptionId;
        return this;
    }

    /**
     * Get the isStorageSecondaryKeyInUse value.
     *
     * @return the isStorageSecondaryKeyInUse value
     */
    public Boolean isStorageSecondaryKeyInUse() {
        return this.isStorageSecondaryKeyInUse;
    }

    /**
     * Set the isStorageSecondaryKeyInUse value.
     *
     * @param isStorageSecondaryKeyInUse the isStorageSecondaryKeyInUse value to set
     * @return the DatabaseBlobAuditingPolicyInner object itself.
     */
    public DatabaseBlobAuditingPolicyInner withIsStorageSecondaryKeyInUse(Boolean isStorageSecondaryKeyInUse) {
        this.isStorageSecondaryKeyInUse = isStorageSecondaryKeyInUse;
        return this;
    }

}
