/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.sql.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in FailoverGroups.
 */
public class FailoverGroupsInner {
    /** The Retrofit service to perform REST calls. */
    private FailoverGroupsService service;
    /** The service client containing this operation class. */
    private SqlManagementClientImpl client;

    /**
     * Initializes an instance of FailoverGroupsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public FailoverGroupsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = retrofit.create(FailoverGroupsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for FailoverGroups to be
     * used by Retrofit to perform actually REST calls.
     */
    interface FailoverGroupsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body FailoverGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginCreateOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body FailoverGroupInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body FailoverGroupUpdateInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Body FailoverGroupUpdateInner parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups listByServer" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups")
        Observable<Response<ResponseBody>> listByServer(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups failover" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/failover")
        Observable<Response<ResponseBody>> failover(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginFailover" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/failover")
        Observable<Response<ResponseBody>> beginFailover(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups forceFailoverAllowDataLoss" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        Observable<Response<ResponseBody>> forceFailoverAllowDataLoss(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups beginForceFailoverAllowDataLoss" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}/forceFailoverAllowDataLoss")
        Observable<Response<ResponseBody>> beginForceFailoverAllowDataLoss(@Path("resourceGroupName") String resourceGroupName, @Path("serverName") String serverName, @Path("failoverGroupName") String failoverGroupName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.FailoverGroups listByServerNext" })
        @GET
        Observable<Response<ResponseBody>> listByServerNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner get(String resourceGroupName, String serverName, String failoverGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> getAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<FailoverGroupInner> getAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return getWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<ServiceResponse<FailoverGroupInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.get(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FailoverGroupInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FailoverGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FailoverGroupInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner createOrUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().last().body();
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FailoverGroupInner> createOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FailoverGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.createOrUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FailoverGroupInner>() { }.getType());
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner beginCreateOrUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<FailoverGroupInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        return beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates or updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<ServiceResponse<FailoverGroupInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        return service.beginCreateOrUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FailoverGroupInner> clientResponse = beginCreateOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FailoverGroupInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FailoverGroupInner>() { }.getType())
                .register(201, new TypeToken<FailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String serverName, String failoverGroupName) {
        deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return deleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String serverName, String failoverGroupName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginDelete(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner update(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().last().body();
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> updateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FailoverGroupInner> updateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FailoverGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.update(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FailoverGroupInner>() { }.getType());
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner beginUpdate(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).toBlocking().single().body();
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters), serviceCallback);
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<FailoverGroupInner> beginUpdateAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName, parameters).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates a failover group.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param parameters The failover group parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<ServiceResponse<FailoverGroupInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName, FailoverGroupUpdateInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String apiVersion = "2015-05-01-preview";
        return service.beginUpdate(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), parameters, apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FailoverGroupInner> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FailoverGroupInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FailoverGroupInner&gt; object if successful.
     */
    public PagedList<FailoverGroupInner> listByServer(final String resourceGroupName, final String serverName) {
        ServiceResponse<Page<FailoverGroupInner>> response = listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<FailoverGroupInner>(response.body()) {
            @Override
            public Page<FailoverGroupInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FailoverGroupInner>> listByServerAsync(final String resourceGroupName, final String serverName, final ListOperationCallback<FailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerSinglePageAsync(resourceGroupName, serverName),
            new Func1<String, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FailoverGroupInner&gt; object
     */
    public Observable<Page<FailoverGroupInner>> listByServerAsync(final String resourceGroupName, final String serverName) {
        return listByServerWithServiceResponseAsync(resourceGroupName, serverName)
            .map(new Func1<ServiceResponse<Page<FailoverGroupInner>>, Page<FailoverGroupInner>>() {
                @Override
                public Page<FailoverGroupInner> call(ServiceResponse<Page<FailoverGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FailoverGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerWithServiceResponseAsync(final String resourceGroupName, final String serverName) {
        return listByServerSinglePageAsync(resourceGroupName, serverName)
            .concatMap(new Func1<ServiceResponse<Page<FailoverGroupInner>>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(ServiceResponse<Page<FailoverGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the failover groups in a server.
     *
    ServiceResponse<PageImpl1<FailoverGroupInner>> * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
    ServiceResponse<PageImpl1<FailoverGroupInner>> * @param serverName The name of the server containing the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FailoverGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerSinglePageAsync(final String resourceGroupName, final String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<FailoverGroupInner>> result = listByServerDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FailoverGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<FailoverGroupInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<FailoverGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<FailoverGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner failover(String resourceGroupName, String serverName, String failoverGroupName) {
        return failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FailoverGroupInner> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return failoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FailoverGroupInner>> failoverWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.failover(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FailoverGroupInner>() { }.getType());
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner beginFailover(String resourceGroupName, String serverName, String failoverGroupName) {
        return beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> beginFailoverAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<FailoverGroupInner> beginFailoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return beginFailoverWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary server to this server.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<ServiceResponse<FailoverGroupInner>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginFailover(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FailoverGroupInner> clientResponse = beginFailoverDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FailoverGroupInner> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner forceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        return forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().last().body();
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<FailoverGroupInner> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return forceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<FailoverGroupInner>> forceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = service.forceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<FailoverGroupInner>() { }.getType());
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the FailoverGroupInner object if successful.
     */
    public FailoverGroupInner beginForceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        return beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).toBlocking().single().body();
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<FailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName, final ServiceCallback<FailoverGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName), serviceCallback);
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<FailoverGroupInner> beginForceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        return beginForceFailoverAllowDataLossWithServiceResponseAsync(resourceGroupName, serverName, failoverGroupName).map(new Func1<ServiceResponse<FailoverGroupInner>, FailoverGroupInner>() {
            @Override
            public FailoverGroupInner call(ServiceResponse<FailoverGroupInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Fails over from the current primary server to this server. This operation might result in data loss.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @param failoverGroupName The name of the failover group.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the FailoverGroupInner object
     */
    public Observable<ServiceResponse<FailoverGroupInner>> beginForceFailoverAllowDataLossWithServiceResponseAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (failoverGroupName == null) {
            throw new IllegalArgumentException("Parameter failoverGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        final String apiVersion = "2015-05-01-preview";
        return service.beginForceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName, this.client.subscriptionId(), apiVersion, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<FailoverGroupInner>>>() {
                @Override
                public Observable<ServiceResponse<FailoverGroupInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<FailoverGroupInner> clientResponse = beginForceFailoverAllowDataLossDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<FailoverGroupInner> beginForceFailoverAllowDataLossDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<FailoverGroupInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<FailoverGroupInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FailoverGroupInner&gt; object if successful.
     */
    public PagedList<FailoverGroupInner> listByServerNext(final String nextPageLink) {
        ServiceResponse<Page<FailoverGroupInner>> response = listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FailoverGroupInner>(response.body()) {
            @Override
            public Page<FailoverGroupInner> nextPage(String nextPageLink) {
                return listByServerNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FailoverGroupInner>> listByServerNextAsync(final String nextPageLink, final ServiceFuture<List<FailoverGroupInner>> serviceFuture, final ListOperationCallback<FailoverGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByServerNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(String nextPageLink) {
                    return listByServerNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FailoverGroupInner&gt; object
     */
    public Observable<Page<FailoverGroupInner>> listByServerNextAsync(final String nextPageLink) {
        return listByServerNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<FailoverGroupInner>>, Page<FailoverGroupInner>>() {
                @Override
                public Page<FailoverGroupInner> call(ServiceResponse<Page<FailoverGroupInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists the failover groups in a server.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FailoverGroupInner&gt; object
     */
    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerNextWithServiceResponseAsync(final String nextPageLink) {
        return listByServerNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<FailoverGroupInner>>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(ServiceResponse<Page<FailoverGroupInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByServerNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists the failover groups in a server.
     *
    ServiceResponse<PageImpl1<FailoverGroupInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FailoverGroupInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FailoverGroupInner>>> listByServerNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FailoverGroupInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FailoverGroupInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl1<FailoverGroupInner>> result = listByServerNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FailoverGroupInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl1<FailoverGroupInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl1<FailoverGroupInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl1<FailoverGroupInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
