/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import com.microsoft.azure.management.storage.AccessTier;
import com.microsoft.azure.management.storage.CustomDomain;
import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.ProvisioningState;
import com.microsoft.azure.management.storage.PublicEndpoints;
import com.microsoft.azure.management.storage.Sku;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.AccountStatuses;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import java.util.List;
import org.joda.time.DateTime;

@Fluent
public interface StorageAccount
extends GroupableResource,
Refreshable<StorageAccount>,
Updatable<Update>,
Wrapper<StorageAccountInner> {
    public AccountStatuses accountStatuses();

    public Sku sku();

    public Kind kind();

    public DateTime creationTime();

    public CustomDomain customDomain();

    public DateTime lastGeoFailoverTime();

    public ProvisioningState provisioningState();

    public PublicEndpoints endPoints();

    public Encryption encryption();

    public AccessTier accessTier();

    public List<StorageAccountKey> getKeys();

    public List<StorageAccountKey> regenerateKey(String var1);

    public static interface Update
    extends Appliable<StorageAccount>,
    UpdateStages.WithSku,
    UpdateStages.WithCustomDomain,
    UpdateStages.WithEncryption,
    UpdateStages.WithAccessTier,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithAccessTier {
            public Update withAccessTier(AccessTier var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(Encryption var1);
        }

        public static interface WithCustomDomain {
            public Update withCustomDomain(CustomDomain var1);

            public Update withCustomDomain(String var1);

            public Update withCustomDomain(String var1, boolean var2);

            public Update withoutCustomDomain();
        }

        public static interface WithSku {
            public Update withSku(SkuName var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreateAndAccessTier
        extends WithCreate {
            public WithCreate withAccessTier(AccessTier var1);
        }

        public static interface WithCreate
        extends Creatable<StorageAccount>,
        WithSku,
        WithBlobStorageAccountKind,
        WithGeneralPurposeAccountKind,
        WithEncryption,
        WithCustomDomain,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithCustomDomain {
            public WithCreate withCustomDomain(CustomDomain var1);

            public WithCreate withCustomDomain(String var1);

            public WithCreate withCustomDomain(String var1, boolean var2);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(Encryption var1);
        }

        public static interface WithGeneralPurposeAccountKind {
            public WithCreate withGeneralPurposeAccountKind();
        }

        public static interface WithBlobStorageAccountKind {
            public WithCreateAndAccessTier withBlobStorageAccountKind();
        }

        public static interface WithSku {
            public WithCreate withSku(SkuName var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithCreateAndAccessTier {
    }
}

