/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.AccessTier;
import com.microsoft.azure.management.storage.CustomDomain;
import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.ProvisioningState;
import com.microsoft.azure.management.storage.PublicEndpoints;
import com.microsoft.azure.management.storage.Sku;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.AccountStatuses;
import com.microsoft.azure.management.storage.implementation.StorageAccountCreateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountListKeysResultInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountUpdateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountsInner;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

class StorageAccountImpl
extends GroupableResourceImpl<StorageAccount, StorageAccountInner, StorageAccountImpl, StorageManager>
implements StorageAccount,
StorageAccount.Definition,
StorageAccount.Update {
    private PublicEndpoints publicEndpoints;
    private AccountStatuses accountStatuses;
    private StorageAccountCreateParametersInner createParameters = new StorageAccountCreateParametersInner();
    private StorageAccountUpdateParametersInner updateParameters;
    private final StorageAccountsInner client;

    StorageAccountImpl(String name, StorageAccountInner innerModel, StorageAccountsInner client, StorageManager storageManager) {
        super(name, (Resource)innerModel, (ManagerBase)storageManager);
        this.client = client;
    }

    @Override
    public AccountStatuses accountStatuses() {
        if (this.accountStatuses == null) {
            this.accountStatuses = new AccountStatuses(((StorageAccountInner)((Object)this.inner())).statusOfPrimary(), ((StorageAccountInner)((Object)this.inner())).statusOfSecondary());
        }
        return this.accountStatuses;
    }

    @Override
    public Sku sku() {
        return ((StorageAccountInner)((Object)this.inner())).sku();
    }

    @Override
    public Kind kind() {
        return ((StorageAccountInner)((Object)this.inner())).kind();
    }

    @Override
    public DateTime creationTime() {
        return ((StorageAccountInner)((Object)this.inner())).creationTime();
    }

    @Override
    public CustomDomain customDomain() {
        return ((StorageAccountInner)((Object)this.inner())).customDomain();
    }

    @Override
    public DateTime lastGeoFailoverTime() {
        return ((StorageAccountInner)((Object)this.inner())).lastGeoFailoverTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((StorageAccountInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public PublicEndpoints endPoints() {
        if (this.publicEndpoints == null) {
            this.publicEndpoints = new PublicEndpoints(((StorageAccountInner)((Object)this.inner())).primaryEndpoints(), ((StorageAccountInner)((Object)this.inner())).secondaryEndpoints());
        }
        return this.publicEndpoints;
    }

    @Override
    public Encryption encryption() {
        return ((StorageAccountInner)((Object)this.inner())).encryption();
    }

    @Override
    public AccessTier accessTier() {
        return ((StorageAccountInner)((Object)this.inner())).accessTier();
    }

    @Override
    public List<StorageAccountKey> getKeys() {
        StorageAccountListKeysResultInner response = this.client.listKeys(this.resourceGroupName(), this.name());
        return response.keys();
    }

    @Override
    public List<StorageAccountKey> regenerateKey(String keyName) {
        StorageAccountListKeysResultInner response = this.client.regenerateKey(this.resourceGroupName(), this.name(), keyName);
        return response.keys();
    }

    public StorageAccountImpl refresh() {
        StorageAccountInner response = this.client.getProperties(this.resourceGroupName(), this.name());
        this.setInner((Object)response);
        this.clearWrapperProperties();
        return this;
    }

    @Override
    public StorageAccountImpl withSku(SkuName skuName) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(skuName));
        } else {
            this.updateParameters.withSku(new Sku().withName(skuName));
        }
        return this;
    }

    @Override
    public StorageAccountImpl withBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKind() {
        this.createParameters.withKind(Kind.STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withEncryption(Encryption encryption) {
        if (this.isInCreateMode()) {
            this.createParameters.withEncryption(encryption);
        } else {
            this.updateParameters.withEncryption(encryption);
        }
        return this;
    }

    private void clearWrapperProperties() {
        this.accountStatuses = null;
        this.publicEndpoints = null;
    }

    public StorageAccountImpl update() {
        this.updateParameters = new StorageAccountUpdateParametersInner();
        return (StorageAccountImpl)super.update();
    }

    public Observable<StorageAccount> updateResourceAsync() {
        return this.client.updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public StorageAccountImpl withCustomDomain(CustomDomain customDomain) {
        if (this.isInCreateMode()) {
            this.createParameters.withCustomDomain(customDomain);
        } else {
            this.updateParameters.withCustomDomain(customDomain);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name) {
        return this.withCustomDomain(new CustomDomain().withName(name));
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name, boolean useSubDomain) {
        return this.withCustomDomain(new CustomDomain().withName(name).withUseSubDomain(useSubDomain));
    }

    @Override
    public StorageAccountImpl withoutCustomDomain() {
        return this.withCustomDomain(new CustomDomain().withName(""));
    }

    @Override
    public StorageAccountImpl withAccessTier(AccessTier accessTier) {
        if (this.isInCreateMode()) {
            this.createParameters.withAccessTier(accessTier);
        } else {
            if (((StorageAccountInner)((Object)this.inner())).kind() != Kind.BLOB_STORAGE) {
                throw new UnsupportedOperationException("Access tier can not be changed for general purpose storage accounts.");
            }
            this.updateParameters.withAccessTier(accessTier);
        }
        return this;
    }

    public Observable<StorageAccount> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((StorageAccountInner)((Object)this.inner())).getTags());
        return this.client.createAsync(this.resourceGroupName(), this.name(), this.createParameters).flatMap((Func1)new Func1<StorageAccountInner, Observable<StorageAccountInner>>(){

            public Observable<StorageAccountInner> call(StorageAccountInner storageAccountInner) {
                return StorageAccountImpl.this.client.getPropertiesAsync(StorageAccountImpl.this.resourceGroupName(), StorageAccountImpl.this.name());
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<StorageAccount>(){

            public void call(StorageAccount storageAccount) {
                StorageAccountImpl.this.clearWrapperProperties();
            }
        });
    }
}

