/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.storage.CheckNameAvailabilityResult;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccounts;
import com.microsoft.azure.management.storage.implementation.StorageAccountImpl;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountsInner;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import rx.Observable;

class StorageAccountsImpl
extends GroupableResourcesImpl<StorageAccount, StorageAccountImpl, StorageAccountInner, StorageAccountsInner, StorageManager>
implements StorageAccounts {
    StorageAccountsImpl(StorageAccountsInner client, StorageManager storageManager) {
        super((Object)client, (ManagerBase)storageManager);
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResult(((StorageAccountsInner)this.innerCollection).checkNameAvailability(name));
    }

    public PagedList<StorageAccount> list() {
        return this.wrapList(((StorageAccountsInner)this.innerCollection).list());
    }

    public PagedList<StorageAccount> listByGroup(String groupName) {
        return this.wrapList(((StorageAccountsInner)this.innerCollection).listByResourceGroup(groupName));
    }

    public StorageAccount getByGroup(String groupName, String name) {
        return this.wrapModel(((StorageAccountsInner)this.innerCollection).getProperties(groupName, name));
    }

    public Observable<Void> deleteAsync(String groupName, String name) {
        return ((StorageAccountsInner)this.innerCollection).deleteAsync(groupName, name);
    }

    public StorageAccountImpl define(String name) {
        return this.wrapModel(name).withSku(SkuName.STANDARD_GRS).withGeneralPurposeAccountKind();
    }

    protected StorageAccountImpl wrapModel(String name) {
        return new StorageAccountImpl(name, new StorageAccountInner(), (StorageAccountsInner)this.innerCollection, (StorageManager)this.myManager);
    }

    protected StorageAccountImpl wrapModel(StorageAccountInner storageAccountInner) {
        return new StorageAccountImpl(storageAccountInner.name(), storageAccountInner, (StorageAccountsInner)this.innerCollection, (StorageManager)this.myManager);
    }
}

