/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.storage.StorageAccounts;
import com.microsoft.azure.management.storage.Usages;
import com.microsoft.azure.management.storage.implementation.StorageAccountsImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.UsagesImpl;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class StorageManager
extends Manager<StorageManager, StorageManagementClientImpl> {
    private StorageAccounts storageAccounts;
    private Usages storageUsages;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static StorageManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new StorageManager(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build(), subscriptionId);
    }

    public static StorageManager authenticate(RestClient restClient, String subscriptionId) {
        return new StorageManager(restClient, subscriptionId);
    }

    private StorageManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new StorageManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public StorageAccounts storageAccounts() {
        if (this.storageAccounts == null) {
            this.storageAccounts = new StorageAccountsImpl(((StorageManagementClientImpl)((Object)this.innerManagementClient)).storageAccounts(), this);
        }
        return this.storageAccounts;
    }

    public Usages usages() {
        if (this.storageUsages == null) {
            this.storageUsages = new UsagesImpl((StorageManagementClientImpl)((Object)this.innerManagementClient));
        }
        return this.storageUsages;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public StorageManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return StorageManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public StorageManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

