/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.UsageInner;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class UsagesInner {
    private UsagesService service;
    private StorageManagementClientImpl client;

    public UsagesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (UsagesService)retrofit.create(UsagesService.class);
        this.client = client;
    }

    public List<UsageInner> list() {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).getBody();
    }

    public ServiceCall<List<UsageInner>> listAsync(ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceCall.create(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<UsageInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = UsagesInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.getBody()).getItems(), result.getResponse());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface UsagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/usages")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

