/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.AccessTier;
import com.microsoft.azure.management.storage.CustomDomain;
import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.ProvisioningState;
import com.microsoft.azure.management.storage.PublicEndpoints;
import com.microsoft.azure.management.storage.Sku;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.AccountStatuses;
import com.microsoft.azure.management.storage.implementation.StorageAccountCreateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountListKeysResultInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountUpdateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountsInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

class StorageAccountImpl
extends GroupableResourceImpl<StorageAccount, StorageAccountInner, StorageAccountImpl, StorageManager>
implements StorageAccount,
StorageAccount.Definition,
StorageAccount.Update {
    private PublicEndpoints publicEndpoints;
    private AccountStatuses accountStatuses;
    private StorageAccountCreateParametersInner createParameters = new StorageAccountCreateParametersInner();
    private StorageAccountUpdateParametersInner updateParameters;

    StorageAccountImpl(String name, StorageAccountInner innerModel, StorageManager storageManager) {
        super(name, (Resource)innerModel, (ManagerBase)storageManager);
    }

    @Override
    public AccountStatuses accountStatuses() {
        if (this.accountStatuses == null) {
            this.accountStatuses = new AccountStatuses(((StorageAccountInner)((Object)this.inner())).statusOfPrimary(), ((StorageAccountInner)((Object)this.inner())).statusOfSecondary());
        }
        return this.accountStatuses;
    }

    @Override
    public Sku sku() {
        return ((StorageAccountInner)((Object)this.inner())).sku();
    }

    @Override
    public Kind kind() {
        return ((StorageAccountInner)((Object)this.inner())).kind();
    }

    @Override
    public DateTime creationTime() {
        return ((StorageAccountInner)((Object)this.inner())).creationTime();
    }

    @Override
    public CustomDomain customDomain() {
        return ((StorageAccountInner)((Object)this.inner())).customDomain();
    }

    @Override
    public DateTime lastGeoFailoverTime() {
        return ((StorageAccountInner)((Object)this.inner())).lastGeoFailoverTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((StorageAccountInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public PublicEndpoints endPoints() {
        if (this.publicEndpoints == null) {
            this.publicEndpoints = new PublicEndpoints(((StorageAccountInner)((Object)this.inner())).primaryEndpoints(), ((StorageAccountInner)((Object)this.inner())).secondaryEndpoints());
        }
        return this.publicEndpoints;
    }

    @Override
    public Encryption encryption() {
        return ((StorageAccountInner)((Object)this.inner())).encryption();
    }

    @Override
    public AccessTier accessTier() {
        return ((StorageAccountInner)((Object)this.inner())).accessTier();
    }

    @Override
    public List<StorageAccountKey> getKeys() {
        return (List)this.getKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<List<StorageAccountKey>> getKeysAsync() {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<StorageAccountListKeysResultInner, List<StorageAccountKey>>(){

            public List<StorageAccountKey> call(StorageAccountListKeysResultInner storageAccountListKeysResultInner) {
                return storageAccountListKeysResultInner.keys();
            }
        });
    }

    @Override
    public ServiceFuture<List<StorageAccountKey>> getKeysAsync(ServiceCallback<List<StorageAccountKey>> callback) {
        return ServiceFuture.fromBody(this.getKeysAsync(), callback);
    }

    @Override
    public List<StorageAccountKey> regenerateKey(String keyName) {
        return (List)this.regenerateKeyAsync(keyName).toBlocking().last();
    }

    @Override
    public Observable<List<StorageAccountKey>> regenerateKeyAsync(String keyName) {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), keyName).map((Func1)new Func1<StorageAccountListKeysResultInner, List<StorageAccountKey>>(){

            public List<StorageAccountKey> call(StorageAccountListKeysResultInner storageAccountListKeysResultInner) {
                return storageAccountListKeysResultInner.keys();
            }
        });
    }

    @Override
    public ServiceFuture<List<StorageAccountKey>> regenerateKeyAsync(String keyName, ServiceCallback<List<StorageAccountKey>> callback) {
        return ServiceFuture.fromBody(this.regenerateKeyAsync(keyName), callback);
    }

    public Observable<StorageAccount> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<StorageAccount, StorageAccount>(){

            public StorageAccount call(StorageAccount storageAccount) {
                StorageAccountImpl impl = (StorageAccountImpl)storageAccount;
                impl.clearWrapperProperties();
                return impl;
            }
        });
    }

    protected Observable<StorageAccountInner> getInnerAsync() {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public StorageAccountImpl withSku(SkuName skuName) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(skuName));
        } else {
            this.updateParameters.withSku(new Sku().withName(skuName));
        }
        return this;
    }

    @Override
    public StorageAccountImpl withBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKind() {
        this.createParameters.withKind(Kind.STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withEncryption(Encryption encryption) {
        if (this.isInCreateMode()) {
            this.createParameters.withEncryption(encryption);
        } else {
            this.updateParameters.withEncryption(encryption);
        }
        return this;
    }

    private void clearWrapperProperties() {
        this.accountStatuses = null;
        this.publicEndpoints = null;
    }

    public StorageAccountImpl update() {
        this.updateParameters = new StorageAccountUpdateParametersInner();
        return (StorageAccountImpl)super.update();
    }

    public Observable<StorageAccount> updateResourceAsync() {
        this.updateParameters.withTags(((StorageAccountInner)((Object)this.inner())).getTags());
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public StorageAccountImpl withCustomDomain(CustomDomain customDomain) {
        if (this.isInCreateMode()) {
            this.createParameters.withCustomDomain(customDomain);
        } else {
            this.updateParameters.withCustomDomain(customDomain);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name) {
        return this.withCustomDomain(new CustomDomain().withName(name));
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name, boolean useSubDomain) {
        return this.withCustomDomain(new CustomDomain().withName(name).withUseSubDomain(useSubDomain));
    }

    @Override
    public StorageAccountImpl withAccessTier(AccessTier accessTier) {
        if (this.isInCreateMode()) {
            this.createParameters.withAccessTier(accessTier);
        } else {
            if (((StorageAccountInner)((Object)this.inner())).kind() != Kind.BLOB_STORAGE) {
                throw new UnsupportedOperationException("Access tier can not be changed for general purpose storage accounts.");
            }
            this.updateParameters.withAccessTier(accessTier);
        }
        return this;
    }

    public Observable<StorageAccount> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((StorageAccountInner)((Object)this.inner())).getTags());
        final StorageAccountsInner client = ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts();
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().createAsync(this.resourceGroupName(), this.name(), this.createParameters).flatMap((Func1)new Func1<StorageAccountInner, Observable<StorageAccountInner>>(){

            public Observable<StorageAccountInner> call(StorageAccountInner storageAccountInner) {
                return client.getByResourceGroupAsync(StorageAccountImpl.this.resourceGroupName(), StorageAccountImpl.this.name());
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<StorageAccount>(){

            public void call(StorageAccount storageAccount) {
                StorageAccountImpl.this.clearWrapperProperties();
            }
        });
    }
}

