/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.SkuInformationInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class SkusInner {
    private SkusService service;
    private StorageManagementClientImpl client;

    public SkusInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (SkusService)retrofit.create(SkusService.class);
        this.client = client;
    }

    public PagedList<SkuInformationInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<SkuInformationInner>(page){

            public Page<SkuInformationInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<SkuInformationInner>> listAsync(ServiceCallback<List<SkuInformationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<SkuInformationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<SkuInformationInner>>, Page<SkuInformationInner>>(){

            public Page<SkuInformationInner> call(ServiceResponse<List<SkuInformationInner>> response) {
                PageImpl<SkuInformationInner> page = new PageImpl<SkuInformationInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<SkuInformationInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SkuInformationInner>>>>(){

            public Observable<ServiceResponse<List<SkuInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SkusInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SkuInformationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SkuInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SkusService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.Skus list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/skus")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

