/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.AccessTier;
import com.microsoft.azure.management.storage.AzureFilesIdentityBasedAuthentication;
import com.microsoft.azure.management.storage.CustomDomain;
import com.microsoft.azure.management.storage.DirectoryServiceOptions;
import com.microsoft.azure.management.storage.Encryption;
import com.microsoft.azure.management.storage.Identity;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.LargeFileSharesState;
import com.microsoft.azure.management.storage.ProvisioningState;
import com.microsoft.azure.management.storage.PublicEndpoints;
import com.microsoft.azure.management.storage.Sku;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountCreateParameters;
import com.microsoft.azure.management.storage.StorageAccountEncryptionKeySource;
import com.microsoft.azure.management.storage.StorageAccountEncryptionStatus;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.StorageAccountSkuType;
import com.microsoft.azure.management.storage.StorageAccountUpdateParameters;
import com.microsoft.azure.management.storage.StorageService;
import com.microsoft.azure.management.storage.implementation.AccountStatuses;
import com.microsoft.azure.management.storage.implementation.SkuInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountListKeysResultInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountsInner;
import com.microsoft.azure.management.storage.implementation.StorageEncryptionHelper;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.management.storage.implementation.StorageNetworkRulesHelper;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

@LangDefinition
class StorageAccountImpl
extends GroupableResourceImpl<StorageAccount, StorageAccountInner, StorageAccountImpl, StorageManager>
implements StorageAccount,
StorageAccount.Definition,
StorageAccount.Update {
    private PublicEndpoints publicEndpoints;
    private AccountStatuses accountStatuses;
    private StorageAccountCreateParameters createParameters = new StorageAccountCreateParameters();
    private StorageAccountUpdateParameters updateParameters;
    private StorageNetworkRulesHelper networkRulesHelper = new StorageNetworkRulesHelper(this.createParameters);
    private StorageEncryptionHelper encryptionHelper = new StorageEncryptionHelper(this.createParameters);

    StorageAccountImpl(String name, StorageAccountInner innerModel, StorageManager storageManager) {
        super(name, (Resource)innerModel, (ManagerBase)storageManager);
    }

    @Override
    public AccountStatuses accountStatuses() {
        if (this.accountStatuses == null) {
            this.accountStatuses = new AccountStatuses(((StorageAccountInner)((Object)this.inner())).statusOfPrimary(), ((StorageAccountInner)((Object)this.inner())).statusOfSecondary());
        }
        return this.accountStatuses;
    }

    @Override
    @Deprecated
    public Sku sku() {
        return new Sku().withName(((StorageAccountInner)((Object)this.inner())).sku().name());
    }

    @Override
    public StorageAccountSkuType skuType() {
        return StorageAccountSkuType.fromSkuName(((StorageAccountInner)((Object)this.inner())).sku().name());
    }

    @Override
    public Kind kind() {
        return ((StorageAccountInner)((Object)this.inner())).kind();
    }

    @Override
    public DateTime creationTime() {
        return ((StorageAccountInner)((Object)this.inner())).creationTime();
    }

    @Override
    public CustomDomain customDomain() {
        return ((StorageAccountInner)((Object)this.inner())).customDomain();
    }

    @Override
    public DateTime lastGeoFailoverTime() {
        return ((StorageAccountInner)((Object)this.inner())).lastGeoFailoverTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((StorageAccountInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public PublicEndpoints endPoints() {
        if (this.publicEndpoints == null) {
            this.publicEndpoints = new PublicEndpoints(((StorageAccountInner)((Object)this.inner())).primaryEndpoints(), ((StorageAccountInner)((Object)this.inner())).secondaryEndpoints());
        }
        return this.publicEndpoints;
    }

    @Override
    @Deprecated
    public Encryption encryption() {
        return ((StorageAccountInner)((Object)this.inner())).encryption();
    }

    @Override
    public StorageAccountEncryptionKeySource encryptionKeySource() {
        return StorageEncryptionHelper.encryptionKeySource((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses() {
        return StorageEncryptionHelper.encryptionStatuses((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public AccessTier accessTier() {
        return ((StorageAccountInner)((Object)this.inner())).accessTier();
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((StorageAccountInner)((Object)this.inner())).identity() == null) {
            return null;
        }
        return ((StorageAccountInner)((Object)this.inner())).identity().tenantId();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((StorageAccountInner)((Object)this.inner())).identity() == null) {
            return null;
        }
        return ((StorageAccountInner)((Object)this.inner())).identity().principalId();
    }

    @Override
    public boolean isAccessAllowedFromAllNetworks() {
        return StorageNetworkRulesHelper.isAccessAllowedFromAllNetworks((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public List<String> networkSubnetsWithAccess() {
        return StorageNetworkRulesHelper.networkSubnetsWithAccess((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public List<String> ipAddressesWithAccess() {
        return StorageNetworkRulesHelper.ipAddressesWithAccess((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public List<String> ipAddressRangesWithAccess() {
        return StorageNetworkRulesHelper.ipAddressRangesWithAccess((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public boolean canReadLogEntriesFromAnyNetwork() {
        return StorageNetworkRulesHelper.canReadLogEntriesFromAnyNetwork((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public boolean canReadMetricsFromAnyNetwork() {
        return StorageNetworkRulesHelper.canReadMetricsFromAnyNetwork((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public boolean canAccessFromAzureServices() {
        return StorageNetworkRulesHelper.canAccessFromAzureServices((StorageAccountInner)((Object)this.inner()));
    }

    @Override
    public boolean isAzureFilesAadIntegrationEnabled() {
        return ((StorageAccountInner)((Object)this.inner())).azureFilesIdentityBasedAuthentication() != null && ((StorageAccountInner)((Object)this.inner())).azureFilesIdentityBasedAuthentication().directoryServiceOptions() == DirectoryServiceOptions.AADDS;
    }

    @Override
    public boolean isHnsEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((StorageAccountInner)((Object)this.inner())).isHnsEnabled());
    }

    @Override
    public boolean isLargeFileSharesEnabled() {
        return ((StorageAccountInner)((Object)this.inner())).largeFileSharesState() == LargeFileSharesState.ENABLED;
    }

    @Override
    public List<StorageAccountKey> getKeys() {
        return (List)this.getKeysAsync().toBlocking().last();
    }

    @Override
    public Observable<List<StorageAccountKey>> getKeysAsync() {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().listKeysAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<StorageAccountListKeysResultInner, List<StorageAccountKey>>(){

            public List<StorageAccountKey> call(StorageAccountListKeysResultInner storageAccountListKeysResultInner) {
                return storageAccountListKeysResultInner.keys();
            }
        });
    }

    @Override
    public ServiceFuture<List<StorageAccountKey>> getKeysAsync(ServiceCallback<List<StorageAccountKey>> callback) {
        return ServiceFuture.fromBody(this.getKeysAsync(), callback);
    }

    @Override
    public List<StorageAccountKey> regenerateKey(String keyName) {
        return (List)this.regenerateKeyAsync(keyName).toBlocking().last();
    }

    @Override
    public Observable<List<StorageAccountKey>> regenerateKeyAsync(String keyName) {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().regenerateKeyAsync(this.resourceGroupName(), this.name(), keyName).map((Func1)new Func1<StorageAccountListKeysResultInner, List<StorageAccountKey>>(){

            public List<StorageAccountKey> call(StorageAccountListKeysResultInner storageAccountListKeysResultInner) {
                return storageAccountListKeysResultInner.keys();
            }
        });
    }

    @Override
    public ServiceFuture<List<StorageAccountKey>> regenerateKeyAsync(String keyName, ServiceCallback<List<StorageAccountKey>> callback) {
        return ServiceFuture.fromBody(this.regenerateKeyAsync(keyName), callback);
    }

    public Observable<StorageAccount> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<StorageAccount, StorageAccount>(){

            public StorageAccount call(StorageAccount storageAccount) {
                StorageAccountImpl impl = (StorageAccountImpl)storageAccount;
                impl.clearWrapperProperties();
                return impl;
            }
        });
    }

    protected Observable<StorageAccountInner> getInnerAsync() {
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    @Deprecated
    public StorageAccountImpl withSku(SkuName skuName) {
        return this.withSku(StorageAccountSkuType.fromSkuName(skuName));
    }

    @Override
    public StorageAccountImpl withSku(StorageAccountSkuType sku) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new SkuInner().withName(sku.name()));
        } else {
            this.updateParameters.withSku(new SkuInner().withName(sku.name()));
        }
        return this;
    }

    @Override
    public StorageAccountImpl withBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKind() {
        this.createParameters.withKind(Kind.STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withGeneralPurposeAccountKindV2() {
        this.createParameters.withKind(Kind.STORAGE_V2);
        return this;
    }

    @Override
    public StorageAccountImpl withBlockBlobStorageAccountKind() {
        this.createParameters.withKind(Kind.BLOCK_BLOB_STORAGE);
        return this;
    }

    @Override
    public StorageAccountImpl withFileStorageAccountKind() {
        this.createParameters.withKind(Kind.FILE_STORAGE);
        return this;
    }

    @Override
    @Deprecated
    public StorageAccountImpl withEncryption() {
        return this.withBlobEncryption();
    }

    @Override
    public StorageAccountImpl withBlobEncryption() {
        this.encryptionHelper.withBlobEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withFileEncryption() {
        this.encryptionHelper.withFileEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withEncryptionKeyFromKeyVault(String keyVaultUri, String keyName, String keyVersion) {
        this.encryptionHelper.withEncryptionKeyFromKeyVault(keyVaultUri, keyName, keyVersion);
        return this;
    }

    @Override
    @Deprecated
    public StorageAccountImpl withoutEncryption() {
        return this.withoutBlobEncryption();
    }

    @Override
    public StorageAccountImpl withoutBlobEncryption() {
        this.encryptionHelper.withoutBlobEncryption();
        return this;
    }

    @Override
    public StorageAccountImpl withoutFileEncryption() {
        this.encryptionHelper.withoutFileEncryption();
        return this;
    }

    private void clearWrapperProperties() {
        this.accountStatuses = null;
        this.publicEndpoints = null;
    }

    public StorageAccountImpl update() {
        this.createParameters = null;
        this.updateParameters = new StorageAccountUpdateParameters();
        this.networkRulesHelper = new StorageNetworkRulesHelper(this.updateParameters, (StorageAccountInner)((Object)this.inner()));
        this.encryptionHelper = new StorageEncryptionHelper(this.updateParameters, (StorageAccountInner)((Object)this.inner()));
        return (StorageAccountImpl)super.update();
    }

    @Override
    public StorageAccountImpl withCustomDomain(CustomDomain customDomain) {
        if (this.isInCreateMode()) {
            this.createParameters.withCustomDomain(customDomain);
        } else {
            this.updateParameters.withCustomDomain(customDomain);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name) {
        return this.withCustomDomain(new CustomDomain().withName(name));
    }

    @Override
    public StorageAccountImpl withCustomDomain(String name, boolean useSubDomain) {
        return this.withCustomDomain(new CustomDomain().withName(name).withUseSubDomainName(useSubDomain));
    }

    @Override
    public StorageAccountImpl withAccessTier(AccessTier accessTier) {
        if (this.isInCreateMode()) {
            this.createParameters.withAccessTier(accessTier);
        } else {
            if (((StorageAccountInner)((Object)this.inner())).kind() != Kind.BLOB_STORAGE) {
                throw new UnsupportedOperationException("Access tier can not be changed for general purpose storage accounts.");
            }
            this.updateParameters.withAccessTier(accessTier);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withSystemAssignedManagedServiceIdentity() {
        if (((StorageAccountInner)((Object)this.inner())).identity() == null) {
            if (this.isInCreateMode()) {
                this.createParameters.withIdentity(new Identity().withType("SystemAssigned"));
            } else {
                this.updateParameters.withIdentity(new Identity().withType("SystemAssigned"));
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withOnlyHttpsTraffic() {
        if (this.isInCreateMode()) {
            this.createParameters.withEnableHttpsTrafficOnly(true);
        } else {
            this.updateParameters.withEnableHttpsTrafficOnly(true);
        }
        return this;
    }

    @Override
    public StorageAccountImpl withHttpAndHttpsTraffic() {
        this.updateParameters.withEnableHttpsTrafficOnly(false);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromAllNetworks() {
        this.networkRulesHelper.withAccessFromAllNetworks();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromSelectedNetworks() {
        this.networkRulesHelper.withAccessFromSelectedNetworks();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromNetworkSubnet(String subnetId) {
        this.networkRulesHelper.withAccessFromNetworkSubnet(subnetId);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromIpAddress(String ipAddress) {
        this.networkRulesHelper.withAccessFromIpAddress(ipAddress);
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromIpAddressRange(String ipAddressCidr) {
        this.networkRulesHelper.withAccessFromIpAddressRange(ipAddressCidr);
        return this;
    }

    @Override
    public StorageAccountImpl withReadAccessToLogEntriesFromAnyNetwork() {
        this.networkRulesHelper.withReadAccessToLoggingFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccountImpl withReadAccessToMetricsFromAnyNetwork() {
        this.networkRulesHelper.withReadAccessToMetricsFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccountImpl withAccessFromAzureServices() {
        this.networkRulesHelper.withAccessAllowedFromAzureServices();
        return this;
    }

    @Override
    public StorageAccountImpl withoutNetworkSubnetAccess(String subnetId) {
        this.networkRulesHelper.withoutNetworkSubnetAccess(subnetId);
        return this;
    }

    @Override
    public StorageAccountImpl withoutIpAddressAccess(String ipAddress) {
        this.networkRulesHelper.withoutIpAddressAccess(ipAddress);
        return this;
    }

    @Override
    public StorageAccountImpl withoutIpAddressRangeAccess(String ipAddressCidr) {
        this.networkRulesHelper.withoutIpAddressRangeAccess(ipAddressCidr);
        return this;
    }

    @Override
    public StorageAccount.Update withoutReadAccessToLoggingFromAnyNetwork() {
        this.networkRulesHelper.withoutReadAccessToLoggingFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccount.Update withoutReadAccessToMetricsFromAnyNetwork() {
        this.networkRulesHelper.withoutReadAccessToMetricsFromAnyNetwork();
        return this;
    }

    @Override
    public StorageAccount.Update withoutAccessFromAzureServices() {
        this.networkRulesHelper.withoutAccessFromAzureServices();
        return this;
    }

    @Override
    public StorageAccount.Update upgradeToGeneralPurposeAccountKindV2() {
        this.updateParameters.withKind(Kind.STORAGE_V2);
        return this;
    }

    public Observable<StorageAccount> createResourceAsync() {
        this.networkRulesHelper.setDefaultActionIfRequired();
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((StorageAccountInner)((Object)this.inner())).getTags());
        final StorageAccountsInner client = ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts();
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().createAsync(this.resourceGroupName(), this.name(), this.createParameters).flatMap((Func1)new Func1<StorageAccountInner, Observable<StorageAccountInner>>(){

            public Observable<StorageAccountInner> call(StorageAccountInner storageAccountInner) {
                return client.getByResourceGroupAsync(StorageAccountImpl.this.resourceGroupName(), StorageAccountImpl.this.name());
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<StorageAccount>(){

            public void call(StorageAccount storageAccount) {
                StorageAccountImpl.this.clearWrapperProperties();
            }
        });
    }

    public Observable<StorageAccount> updateResourceAsync() {
        this.networkRulesHelper.setDefaultActionIfRequired();
        this.updateParameters.withTags(((StorageAccountInner)((Object)this.inner())).getTags());
        return ((StorageManagementClientImpl)((Object)((StorageManager)this.manager()).inner())).storageAccounts().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).doOnNext((Action1)new Action1<StorageAccount>(){

            public void call(StorageAccount storageAccount) {
                StorageAccountImpl.this.clearWrapperProperties();
            }
        });
    }

    @Override
    public StorageAccountImpl withAzureFilesAadIntegrationEnabled(boolean enabled) {
        if (this.isInCreateMode()) {
            if (enabled) {
                this.createParameters.withAzureFilesIdentityBasedAuthentication(new AzureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.AADDS));
            }
        } else {
            if (this.createParameters.azureFilesIdentityBasedAuthentication() == null) {
                this.createParameters.withAzureFilesIdentityBasedAuthentication(new AzureFilesIdentityBasedAuthentication());
            }
            if (enabled) {
                this.updateParameters.azureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.AADDS);
            } else {
                this.updateParameters.azureFilesIdentityBasedAuthentication().withDirectoryServiceOptions(DirectoryServiceOptions.NONE);
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withLargeFileShares(boolean enabled) {
        if (this.isInCreateMode()) {
            if (enabled) {
                this.createParameters.withLargeFileSharesState(LargeFileSharesState.ENABLED);
            } else {
                this.createParameters.withLargeFileSharesState(LargeFileSharesState.DISABLED);
            }
        }
        return this;
    }

    @Override
    public StorageAccountImpl withHnsEnabled(boolean enabled) {
        this.createParameters.withIsHnsEnabled(enabled);
        return this;
    }
}

