/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.storage.ErrorResponseException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in ObjectReplicationPolicies.
 */
public class ObjectReplicationPoliciesInner {
    /** The Retrofit service to perform REST calls. */
    private ObjectReplicationPoliciesService service;
    /** The service client containing this operation class. */
    private StorageManagementClientImpl client;

    /**
     * Initializes an instance of ObjectReplicationPoliciesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public ObjectReplicationPoliciesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = retrofit.create(ObjectReplicationPoliciesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for ObjectReplicationPolicies to be
     * used by Retrofit to perform actually REST calls.
     */
    interface ObjectReplicationPoliciesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies list" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies")
        Observable<Response<ResponseBody>> list(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("objectReplicationPolicyId") String objectReplicationPolicyId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies createOrUpdate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}")
        Observable<Response<ResponseBody>> createOrUpdate(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("objectReplicationPolicyId") String objectReplicationPolicyId, @Query("api-version") String apiVersion, @Body ObjectReplicationPolicyInner properties, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.ObjectReplicationPolicies delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Path("objectReplicationPolicyId") String objectReplicationPolicyId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * List the object replication policies associated with the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the List&lt;ObjectReplicationPolicyInner&gt; object if successful.
     */
    public List<ObjectReplicationPolicyInner> list(String resourceGroupName, String accountName) {
        return listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single().body();
    }

    /**
     * List the object replication policies associated with the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<ObjectReplicationPolicyInner>> listAsync(String resourceGroupName, String accountName, final ServiceCallback<List<ObjectReplicationPolicyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    /**
     * List the object replication policies associated with the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ObjectReplicationPolicyInner&gt; object
     */
    public Observable<List<ObjectReplicationPolicyInner>> listAsync(String resourceGroupName, String accountName) {
        return listWithServiceResponseAsync(resourceGroupName, accountName).map(new Func1<ServiceResponse<List<ObjectReplicationPolicyInner>>, List<ObjectReplicationPolicyInner>>() {
            @Override
            public List<ObjectReplicationPolicyInner> call(ServiceResponse<List<ObjectReplicationPolicyInner>> response) {
                return response.body();
            }
        });
    }

    /**
     * List the object replication policies associated with the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the List&lt;ObjectReplicationPolicyInner&gt; object
     */
    public Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>>>() {
                @Override
                public Observable<ServiceResponse<List<ObjectReplicationPolicyInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<ObjectReplicationPolicyInner>> result = listDelegate(response);
                        List<ObjectReplicationPolicyInner> items = null;
                        if (result.body() != null) {
                            items = result.body().items();
                        }
                        ServiceResponse<List<ObjectReplicationPolicyInner>> clientResponse = new ServiceResponse<List<ObjectReplicationPolicyInner>>(items, result.response());
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<ObjectReplicationPolicyInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<ObjectReplicationPolicyInner>, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<ObjectReplicationPolicyInner>>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Get the object replication policy of the storage account by policy ID.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ObjectReplicationPolicyInner object if successful.
     */
    public ObjectReplicationPolicyInner get(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).toBlocking().single().body();
    }

    /**
     * Get the object replication policy of the storage account by policy ID.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ObjectReplicationPolicyInner> getAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, final ServiceCallback<ObjectReplicationPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId), serviceCallback);
    }

    /**
     * Get the object replication policy of the storage account by policy ID.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ObjectReplicationPolicyInner object
     */
    public Observable<ObjectReplicationPolicyInner> getAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).map(new Func1<ServiceResponse<ObjectReplicationPolicyInner>, ObjectReplicationPolicyInner>() {
            @Override
            public ObjectReplicationPolicyInner call(ServiceResponse<ObjectReplicationPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Get the object replication policy of the storage account by policy ID.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ObjectReplicationPolicyInner object
     */
    public Observable<ServiceResponse<ObjectReplicationPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ObjectReplicationPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ObjectReplicationPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ObjectReplicationPolicyInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ObjectReplicationPolicyInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ObjectReplicationPolicyInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ObjectReplicationPolicyInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Create or update the object replication policy of the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param properties The object replication policy set to a storage account. A unique policy ID will be created if absent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the ObjectReplicationPolicyInner object if successful.
     */
    public ObjectReplicationPolicyInner createOrUpdate(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties).toBlocking().single().body();
    }

    /**
     * Create or update the object replication policy of the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param properties The object replication policy set to a storage account. A unique policy ID will be created if absent.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<ObjectReplicationPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties, final ServiceCallback<ObjectReplicationPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties), serviceCallback);
    }

    /**
     * Create or update the object replication policy of the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param properties The object replication policy set to a storage account. A unique policy ID will be created if absent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ObjectReplicationPolicyInner object
     */
    public Observable<ObjectReplicationPolicyInner> createOrUpdateAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        return createOrUpdateWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId, properties).map(new Func1<ServiceResponse<ObjectReplicationPolicyInner>, ObjectReplicationPolicyInner>() {
            @Override
            public ObjectReplicationPolicyInner call(ServiceResponse<ObjectReplicationPolicyInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Create or update the object replication policy of the storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param properties The object replication policy set to a storage account. A unique policy ID will be created if absent.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the ObjectReplicationPolicyInner object
     */
    public Observable<ServiceResponse<ObjectReplicationPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, ObjectReplicationPolicyInner properties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is required and cannot be null.");
        }
        Validator.validate(properties);
        return service.createOrUpdate(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), properties, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<ObjectReplicationPolicyInner>>>() {
                @Override
                public Observable<ServiceResponse<ObjectReplicationPolicyInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<ObjectReplicationPolicyInner> clientResponse = createOrUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<ObjectReplicationPolicyInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<ObjectReplicationPolicyInner, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<ObjectReplicationPolicyInner>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

    /**
     * Deletes the object replication policy associated with the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws ErrorResponseException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).toBlocking().single().body();
    }

    /**
     * Deletes the object replication policy associated with the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId), serviceCallback);
    }

    /**
     * Deletes the object replication policy associated with the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        return deleteWithServiceResponseAsync(resourceGroupName, accountName, objectReplicationPolicyId).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the object replication policy associated with the specified storage account.
     *
     * @param resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
     * @param accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     * @param objectReplicationPolicyId The ID of object replication policy or 'default' if the policy ID is unknown.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String objectReplicationPolicyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (objectReplicationPolicyId == null) {
            throw new IllegalArgumentException("Parameter objectReplicationPolicyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.delete(resourceGroupName, accountName, this.client.subscriptionId(), objectReplicationPolicyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = deleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, ErrorResponseException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(ErrorResponseException.class)
                .build(response);
    }

}
