/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.SkuTier;
import com.microsoft.azure.management.storage.Kind;
import java.util.List;
import com.microsoft.azure.management.storage.SKUCapability;
import com.microsoft.azure.management.storage.Restriction;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Storage SKU and its properties.
 */
public class SkuInformationInner {
    /**
     * Possible values include: 'Standard_LRS', 'Standard_GRS',
     * 'Standard_RAGRS', 'Standard_ZRS', 'Premium_LRS', 'Premium_ZRS',
     * 'Standard_GZRS', 'Standard_RAGZRS'.
     */
    @JsonProperty(value = "name", required = true)
    private SkuName name;

    /**
     * Possible values include: 'Standard', 'Premium'.
     */
    @JsonProperty(value = "tier")
    private SkuTier tier;

    /**
     * The type of the resource, usually it is 'storageAccounts'.
     */
    @JsonProperty(value = "resourceType", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceType;

    /**
     * Indicates the type of storage account. Possible values include:
     * 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage',
     * 'BlockBlobStorage'.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private Kind kind;

    /**
     * The set of locations that the SKU is available. This will be supported
     * and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
     * etc.).
     */
    @JsonProperty(value = "locations", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> locations;

    /**
     * The capability information in the specified SKU, including file
     * encryption, network ACLs, change notification, etc.
     */
    @JsonProperty(value = "capabilities", access = JsonProperty.Access.WRITE_ONLY)
    private List<SKUCapability> capabilities;

    /**
     * The restrictions because of which SKU cannot be used. This is empty if
     * there are no restrictions.
     */
    @JsonProperty(value = "restrictions")
    private List<Restriction> restrictions;

    /**
     * Get possible values include: 'Standard_LRS', 'Standard_GRS', 'Standard_RAGRS', 'Standard_ZRS', 'Premium_LRS', 'Premium_ZRS', 'Standard_GZRS', 'Standard_RAGZRS'.
     *
     * @return the name value
     */
    public SkuName name() {
        return this.name;
    }

    /**
     * Set possible values include: 'Standard_LRS', 'Standard_GRS', 'Standard_RAGRS', 'Standard_ZRS', 'Premium_LRS', 'Premium_ZRS', 'Standard_GZRS', 'Standard_RAGZRS'.
     *
     * @param name the name value to set
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get possible values include: 'Standard', 'Premium'.
     *
     * @return the tier value
     */
    public SkuTier tier() {
        return this.tier;
    }

    /**
     * Set possible values include: 'Standard', 'Premium'.
     *
     * @param tier the tier value to set
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Get the type of the resource, usually it is 'storageAccounts'.
     *
     * @return the resourceType value
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get indicates the type of storage account. Possible values include: 'Storage', 'StorageV2', 'BlobStorage', 'FileStorage', 'BlockBlobStorage'.
     *
     * @return the kind value
     */
    public Kind kind() {
        return this.kind;
    }

    /**
     * Get the set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
     *
     * @return the locations value
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Get the capability information in the specified SKU, including file encryption, network ACLs, change notification, etc.
     *
     * @return the capabilities value
     */
    public List<SKUCapability> capabilities() {
        return this.capabilities;
    }

    /**
     * Get the restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
     *
     * @return the restrictions value
     */
    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    /**
     * Set the restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
     *
     * @param restrictions the restrictions value to set
     * @return the SkuInformationInner object itself.
     */
    public SkuInformationInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

}
