/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.storage.EncryptionScopeSource;
import com.microsoft.azure.management.storage.EncryptionScopeState;
import org.joda.time.DateTime;
import com.microsoft.azure.management.storage.EncryptionScopeKeyVaultProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * The Encryption Scope resource.
 */
@JsonFlatten
public class EncryptionScopeInner extends ProxyResource {
    /**
     * The provider for the encryption scope. Possible values
     * (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible
     * values include: 'Microsoft.Storage', 'Microsoft.KeyVault'.
     */
    @JsonProperty(value = "properties.source")
    private EncryptionScopeSource source;

    /**
     * The state of the encryption scope. Possible values (case-insensitive):
     * Enabled, Disabled. Possible values include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.state")
    private EncryptionScopeState state;

    /**
     * Gets the creation date and time of the encryption scope in UTC.
     */
    @JsonProperty(value = "properties.creationTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationTime;

    /**
     * Gets the last modification date and time of the encryption scope in UTC.
     */
    @JsonProperty(value = "properties.lastModifiedTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastModifiedTime;

    /**
     * The key vault properties for the encryption scope. This is a required
     * field if encryption scope 'source' attribute is set to
     * 'Microsoft.KeyVault'.
     */
    @JsonProperty(value = "properties.keyVaultProperties")
    private EncryptionScopeKeyVaultProperties keyVaultProperties;

    /**
     * Get the provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible values include: 'Microsoft.Storage', 'Microsoft.KeyVault'.
     *
     * @return the source value
     */
    public EncryptionScopeSource source() {
        return this.source;
    }

    /**
     * Set the provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. Possible values include: 'Microsoft.Storage', 'Microsoft.KeyVault'.
     *
     * @param source the source value to set
     * @return the EncryptionScopeInner object itself.
     */
    public EncryptionScopeInner withSource(EncryptionScopeSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the state value
     */
    public EncryptionScopeState state() {
        return this.state;
    }

    /**
     * Set the state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param state the state value to set
     * @return the EncryptionScopeInner object itself.
     */
    public EncryptionScopeInner withState(EncryptionScopeState state) {
        this.state = state;
        return this;
    }

    /**
     * Get gets the creation date and time of the encryption scope in UTC.
     *
     * @return the creationTime value
     */
    public DateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get gets the last modification date and time of the encryption scope in UTC.
     *
     * @return the lastModifiedTime value
     */
    public DateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     *
     * @return the keyVaultProperties value
     */
    public EncryptionScopeKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     *
     * @param keyVaultProperties the keyVaultProperties value to set
     * @return the EncryptionScopeInner object itself.
     */
    public EncryptionScopeInner withKeyVaultProperties(EncryptionScopeKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

}
