/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage.implementation;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * The StorageQueueInner model.
 */
@JsonFlatten
public class StorageQueueInner extends ProxyResource {
    /**
     * A name-value pair that represents queue metadata.
     */
    @JsonProperty(value = "properties.metadata")
    private Map<String, String> metadata;

    /**
     * Integer indicating an approximate number of messages in the queue. This
     * number is not lower than the actual number of messages in the queue, but
     * could be higher.
     */
    @JsonProperty(value = "properties.approximateMessageCount", access = JsonProperty.Access.WRITE_ONLY)
    private Integer approximateMessageCount;

    /**
     * Get a name-value pair that represents queue metadata.
     *
     * @return the metadata value
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set a name-value pair that represents queue metadata.
     *
     * @param metadata the metadata value to set
     * @return the StorageQueueInner object itself.
     */
    public StorageQueueInner withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get integer indicating an approximate number of messages in the queue. This number is not lower than the actual number of messages in the queue, but could be higher.
     *
     * @return the approximateMessageCount value
     */
    public Integer approximateMessageCount() {
        return this.approximateMessageCount;
    }

}
