/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.storage.AccountSasParameters;
import com.microsoft.azure.management.storage.BlobRestoreParameters;
import com.microsoft.azure.management.storage.BlobRestoreRange;
import com.microsoft.azure.management.storage.ListKeyExpand;
import com.microsoft.azure.management.storage.ServiceSasParameters;
import com.microsoft.azure.management.storage.StorageAccountCheckNameAvailabilityParameters;
import com.microsoft.azure.management.storage.StorageAccountCreateParameters;
import com.microsoft.azure.management.storage.StorageAccountExpand;
import com.microsoft.azure.management.storage.StorageAccountRegenerateKeyParameters;
import com.microsoft.azure.management.storage.StorageAccountUpdateParameters;
import com.microsoft.azure.management.storage.implementation.BlobRestoreStatusInner;
import com.microsoft.azure.management.storage.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.storage.implementation.ListAccountSasResponseInner;
import com.microsoft.azure.management.storage.implementation.ListServiceSasResponseInner;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.PageImpl1;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountListKeysResultInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class StorageAccountsInner
implements InnerSupportsGet<StorageAccountInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<StorageAccountInner> {
    private StorageAccountsService service;
    private StorageManagementClientImpl client;

    public StorageAccountsInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (StorageAccountsService)retrofit.create(StorageAccountsService.class);
        this.client = client;
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        StorageAccountCheckNameAvailabilityParameters accountName = new StorageAccountCheckNameAvailabilityParameters();
        accountName.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), accountName, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner create(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<StorageAccountInner> createAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> createAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<StorageAccountInner>(){}.getType());
    }

    public StorageAccountInner beginCreate(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> beginCreateAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> beginCreateAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner getByResourceGroup(String resourceGroupName, String accountName) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        StorageAccountExpand expand = null;
        return this.service.getByResourceGroup(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public StorageAccountInner getByResourceGroup(String resourceGroupName, String accountName, StorageAccountExpand expand) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, StorageAccountExpand expand, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName, expand), serviceCallback);
    }

    public Observable<StorageAccountInner> getByResourceGroupAsync(String resourceGroupName, String accountName, StorageAccountExpand expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, accountName, expand).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountExpand expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountInner update(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters) {
        return (StorageAccountInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<StorageAccountInner> updateAsync(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters, ServiceCallback<StorageAccountInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<StorageAccountInner> updateAsync(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<StorageAccountInner>, StorageAccountInner>(){

            public StorageAccountInner call(ServiceResponse<StorageAccountInner> response) {
                return (StorageAccountInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, StorageAccountUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountInner>>>(){

            public Observable<ServiceResponse<StorageAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<StorageAccountInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<StorageAccountInner>((Page)response.body()){

            public Page<StorageAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<StorageAccountInner>> listAsync(ListOperationCallback<StorageAccountInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(String nextPageLink) {
                return StorageAccountsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<StorageAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<StorageAccountInner>>, Page<StorageAccountInner>>(){

            public Page<StorageAccountInner> call(ServiceResponse<Page<StorageAccountInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountInner>>, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(ServiceResponse<Page<StorageAccountInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<StorageAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<StorageAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<StorageAccountInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<StorageAccountInner>(page){

            public Page<StorageAccountInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<StorageAccountInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<StorageAccountInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<StorageAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<StorageAccountInner>>, Page<StorageAccountInner>>(){

            public Page<StorageAccountInner> call(ServiceResponse<List<StorageAccountInner>> response) {
                PageImpl<StorageAccountInner> page = new PageImpl<StorageAccountInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<StorageAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<List<StorageAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<StorageAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<StorageAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountListKeysResultInner listKeys(String resourceGroupName, String accountName) {
        return (StorageAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ServiceCallback<StorageAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<StorageAccountListKeysResultInner>, StorageAccountListKeysResultInner>(){

            public StorageAccountListKeysResultInner call(ServiceResponse<StorageAccountListKeysResultInner> response) {
                return (StorageAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ListKeyExpand expand = null;
        return this.service.listKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<StorageAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public StorageAccountListKeysResultInner listKeys(String resourceGroupName, String accountName, ListKeyExpand expand) {
        return (StorageAccountListKeysResultInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, accountName, expand).toBlocking().single()).body();
    }

    public ServiceFuture<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ListKeyExpand expand, ServiceCallback<StorageAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, accountName, expand), serviceCallback);
    }

    public Observable<StorageAccountListKeysResultInner> listKeysAsync(String resourceGroupName, String accountName, ListKeyExpand expand) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, accountName, expand).map((Func1)new Func1<ServiceResponse<StorageAccountListKeysResultInner>, StorageAccountListKeysResultInner>(){

            public StorageAccountListKeysResultInner call(ServiceResponse<StorageAccountListKeysResultInner> response) {
                return (StorageAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountListKeysResultInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String accountName, ListKeyExpand expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<StorageAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountListKeysResultInner> listKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public StorageAccountListKeysResultInner regenerateKey(String resourceGroupName, String accountName, String keyName) {
        return (StorageAccountListKeysResultInner)((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).toBlocking().single()).body();
    }

    public ServiceFuture<StorageAccountListKeysResultInner> regenerateKeyAsync(String resourceGroupName, String accountName, String keyName, ServiceCallback<StorageAccountListKeysResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName), serviceCallback);
    }

    public Observable<StorageAccountListKeysResultInner> regenerateKeyAsync(String resourceGroupName, String accountName, String keyName) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).map((Func1)new Func1<ServiceResponse<StorageAccountListKeysResultInner>, StorageAccountListKeysResultInner>(){

            public StorageAccountListKeysResultInner call(ServiceResponse<StorageAccountListKeysResultInner> response) {
                return (StorageAccountListKeysResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<StorageAccountListKeysResultInner>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, String keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        StorageAccountRegenerateKeyParameters regenerateKey = new StorageAccountRegenerateKeyParameters();
        regenerateKey.withKeyName(keyName);
        return this.service.regenerateKey(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), regenerateKey, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<StorageAccountListKeysResultInner>>>(){

            public Observable<ServiceResponse<StorageAccountListKeysResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.regenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<StorageAccountListKeysResultInner> regenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<StorageAccountListKeysResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ListAccountSasResponseInner listAccountSAS(String resourceGroupName, String accountName, AccountSasParameters parameters) {
        return (ListAccountSasResponseInner)((ServiceResponse)this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ListAccountSasResponseInner> listAccountSASAsync(String resourceGroupName, String accountName, AccountSasParameters parameters, ServiceCallback<ListAccountSasResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<ListAccountSasResponseInner> listAccountSASAsync(String resourceGroupName, String accountName, AccountSasParameters parameters) {
        return this.listAccountSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<ListAccountSasResponseInner>, ListAccountSasResponseInner>(){

            public ListAccountSasResponseInner call(ServiceResponse<ListAccountSasResponseInner> response) {
                return (ListAccountSasResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListAccountSasResponseInner>> listAccountSASWithServiceResponseAsync(String resourceGroupName, String accountName, AccountSasParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.listAccountSAS(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListAccountSasResponseInner>>>(){

            public Observable<ServiceResponse<ListAccountSasResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listAccountSASDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListAccountSasResponseInner> listAccountSASDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListAccountSasResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ListServiceSasResponseInner listServiceSAS(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return (ListServiceSasResponseInner)((ServiceResponse)this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ListServiceSasResponseInner> listServiceSASAsync(String resourceGroupName, String accountName, ServiceSasParameters parameters, ServiceCallback<ListServiceSasResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<ListServiceSasResponseInner> listServiceSASAsync(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        return this.listServiceSASWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<ListServiceSasResponseInner>, ListServiceSasResponseInner>(){

            public ListServiceSasResponseInner call(ServiceResponse<ListServiceSasResponseInner> response) {
                return (ListServiceSasResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListServiceSasResponseInner>> listServiceSASWithServiceResponseAsync(String resourceGroupName, String accountName, ServiceSasParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.listServiceSAS(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListServiceSasResponseInner>>>(){

            public Observable<ServiceResponse<ListServiceSasResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.listServiceSASDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListServiceSasResponseInner> listServiceSASDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListServiceSasResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void failover(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.failoverWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> failoverAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.failoverWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> failoverAsync(String resourceGroupName, String accountName) {
        return this.failoverWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> failoverWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.failover(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginFailover(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginFailoverWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginFailoverAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginFailoverWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginFailoverAsync(String resourceGroupName, String accountName) {
        return this.beginFailoverWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginFailoverWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginFailover(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.beginFailoverDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginFailoverDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobRestoreStatusInner restoreBlobRanges(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        return (BlobRestoreStatusInner)((ServiceResponse)this.restoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges).toBlocking().last()).body();
    }

    public ServiceFuture<BlobRestoreStatusInner> restoreBlobRangesAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges, ServiceCallback<BlobRestoreStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.restoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges), serviceCallback);
    }

    public Observable<BlobRestoreStatusInner> restoreBlobRangesAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        return this.restoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges).map((Func1)new Func1<ServiceResponse<BlobRestoreStatusInner>, BlobRestoreStatusInner>(){

            public BlobRestoreStatusInner call(ServiceResponse<BlobRestoreStatusInner> response) {
                return (BlobRestoreStatusInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BlobRestoreStatusInner>> restoreBlobRangesWithServiceResponseAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (timeToRestore == null) {
            throw new IllegalArgumentException("Parameter timeToRestore is required and cannot be null.");
        }
        if (blobRanges == null) {
            throw new IllegalArgumentException("Parameter blobRanges is required and cannot be null.");
        }
        Validator.validate(blobRanges);
        BlobRestoreParameters parameters = new BlobRestoreParameters();
        parameters.withTimeToRestore(timeToRestore);
        parameters.withBlobRanges(blobRanges);
        Observable<Response<ResponseBody>> observable = this.service.restoreBlobRanges(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<BlobRestoreStatusInner>(){}.getType());
    }

    public BlobRestoreStatusInner beginRestoreBlobRanges(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        return (BlobRestoreStatusInner)((ServiceResponse)this.beginRestoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges).toBlocking().single()).body();
    }

    public ServiceFuture<BlobRestoreStatusInner> beginRestoreBlobRangesAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges, ServiceCallback<BlobRestoreStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRestoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges), serviceCallback);
    }

    public Observable<BlobRestoreStatusInner> beginRestoreBlobRangesAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        return this.beginRestoreBlobRangesWithServiceResponseAsync(resourceGroupName, accountName, timeToRestore, blobRanges).map((Func1)new Func1<ServiceResponse<BlobRestoreStatusInner>, BlobRestoreStatusInner>(){

            public BlobRestoreStatusInner call(ServiceResponse<BlobRestoreStatusInner> response) {
                return (BlobRestoreStatusInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BlobRestoreStatusInner>> beginRestoreBlobRangesWithServiceResponseAsync(String resourceGroupName, String accountName, DateTime timeToRestore, List<BlobRestoreRange> blobRanges) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (timeToRestore == null) {
            throw new IllegalArgumentException("Parameter timeToRestore is required and cannot be null.");
        }
        if (blobRanges == null) {
            throw new IllegalArgumentException("Parameter blobRanges is required and cannot be null.");
        }
        Validator.validate(blobRanges);
        BlobRestoreParameters parameters = new BlobRestoreParameters();
        parameters.withTimeToRestore(timeToRestore);
        parameters.withBlobRanges(blobRanges);
        return this.service.beginRestoreBlobRanges(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobRestoreStatusInner>>>(){

            public Observable<ServiceResponse<BlobRestoreStatusInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.beginRestoreBlobRangesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobRestoreStatusInner> beginRestoreBlobRangesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BlobRestoreStatusInner>(){}.getType()).register(202, new TypeToken<BlobRestoreStatusInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void revokeUserDelegationKeys(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.revokeUserDelegationKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> revokeUserDelegationKeysAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.revokeUserDelegationKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> revokeUserDelegationKeysAsync(String resourceGroupName, String accountName) {
        return this.revokeUserDelegationKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> revokeUserDelegationKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.revokeUserDelegationKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = StorageAccountsInner.this.revokeUserDelegationKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> revokeUserDelegationKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<StorageAccountInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<StorageAccountInner>((Page)response.body()){

            public Page<StorageAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)StorageAccountsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<StorageAccountInner>> listNextAsync(String nextPageLink, ServiceFuture<List<StorageAccountInner>> serviceFuture, ListOperationCallback<StorageAccountInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(String nextPageLink) {
                return StorageAccountsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<StorageAccountInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<StorageAccountInner>>, Page<StorageAccountInner>>(){

            public Page<StorageAccountInner> call(ServiceResponse<Page<StorageAccountInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<StorageAccountInner>>, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(ServiceResponse<Page<StorageAccountInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(StorageAccountsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<StorageAccountInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<StorageAccountInner>>>>(){

            public Observable<ServiceResponse<Page<StorageAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = StorageAccountsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<StorageAccountInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<StorageAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface StorageAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body StorageAccountCheckNameAvailabilityParameters var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") StorageAccountExpand var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body StorageAccountUpdateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Storage/storageAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") ListKeyExpand var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts regenerateKey"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/regenerateKey")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body StorageAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listAccountSAS"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListAccountSas")
        public Observable<Response<ResponseBody>> listAccountSAS(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body AccountSasParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listServiceSAS"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/ListServiceSas")
        public Observable<Response<ResponseBody>> listServiceSAS(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body ServiceSasParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts failover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/failover")
        public Observable<Response<ResponseBody>> failover(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts beginFailover"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/failover")
        public Observable<Response<ResponseBody>> beginFailover(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts restoreBlobRanges"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/restoreBlobRanges")
        public Observable<Response<ResponseBody>> restoreBlobRanges(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BlobRestoreParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts beginRestoreBlobRanges"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/restoreBlobRanges")
        public Observable<Response<ResponseBody>> beginRestoreBlobRanges(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BlobRestoreParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts revokeUserDelegationKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/revokeUserDelegationKeys")
        public Observable<Response<ResponseBody>> revokeUserDelegationKeys(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.StorageAccounts listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

