/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.CorsRules;
import com.microsoft.azure.management.storage.DeleteRetentionPolicy;
import com.microsoft.azure.management.storage.implementation.FileServiceItemsInner;
import com.microsoft.azure.management.storage.implementation.FileServicePropertiesInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class FileServicesInner {
    private FileServicesService service;
    private StorageManagementClientImpl client;

    public FileServicesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (FileServicesService)retrofit.create(FileServicesService.class);
        this.client = client;
    }

    public FileServiceItemsInner list(String resourceGroupName, String accountName) {
        return (FileServiceItemsInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<FileServiceItemsInner> listAsync(String resourceGroupName, String accountName, ServiceCallback<FileServiceItemsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<FileServiceItemsInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<FileServiceItemsInner>, FileServiceItemsInner>(){

            public FileServiceItemsInner call(ServiceResponse<FileServiceItemsInner> response) {
                return (FileServiceItemsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<FileServiceItemsInner>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServiceItemsInner>>>(){

            public Observable<ServiceResponse<FileServiceItemsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServiceItemsInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServiceItemsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName) {
        return (FileServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<FileServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<FileServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<FileServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<FileServicePropertiesInner>, FileServicePropertiesInner>(){

            public FileServicePropertiesInner call(ServiceResponse<FileServicePropertiesInner> response) {
                return (FileServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String fileServicesName = "default";
        Object cors = null;
        Object shareDeleteRetentionPolicy = null;
        FileServicePropertiesInner parameters = new FileServicePropertiesInner();
        parameters.withCors(null);
        parameters.withShareDeleteRetentionPolicy(null);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServicePropertiesInner>>>(){

            public Observable<ServiceResponse<FileServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public FileServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName, CorsRules cors, DeleteRetentionPolicy shareDeleteRetentionPolicy) {
        return (FileServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors, shareDeleteRetentionPolicy).toBlocking().single()).body());
    }

    public ServiceFuture<FileServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors, DeleteRetentionPolicy shareDeleteRetentionPolicy, ServiceCallback<FileServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors, shareDeleteRetentionPolicy), serviceCallback);
    }

    public Observable<FileServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors, DeleteRetentionPolicy shareDeleteRetentionPolicy) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors, shareDeleteRetentionPolicy).map((Func1)new Func1<ServiceResponse<FileServicePropertiesInner>, FileServicePropertiesInner>(){

            public FileServicePropertiesInner call(ServiceResponse<FileServicePropertiesInner> response) {
                return (FileServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName, CorsRules cors, DeleteRetentionPolicy shareDeleteRetentionPolicy) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)cors);
        Validator.validate((Object)shareDeleteRetentionPolicy);
        String fileServicesName = "default";
        FileServicePropertiesInner parameters = new FileServicePropertiesInner();
        parameters.withCors(cors);
        parameters.withShareDeleteRetentionPolicy(shareDeleteRetentionPolicy);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServicePropertiesInner>>>(){

            public Observable<ServiceResponse<FileServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServicePropertiesInner> setServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (FileServicePropertiesInner)((Object)((ServiceResponse)this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<FileServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<FileServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<FileServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<FileServicePropertiesInner>, FileServicePropertiesInner>(){

            public FileServicePropertiesInner call(ServiceResponse<FileServicePropertiesInner> response) {
                return (FileServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServicePropertiesInner>> getServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String fileServicesName = "default";
        return this.service.getServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServicePropertiesInner>>>(){

            public Observable<ServiceResponse<FileServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServicesInner.this.getServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServicePropertiesInner> getServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FileServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileServices list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileServices setServiceProperties"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/{FileServicesName}")
        public Observable<Response<ResponseBody>> setServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="FileServicesName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body FileServicePropertiesInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.FileServices getServiceProperties"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/{FileServicesName}")
        public Observable<Response<ResponseBody>> getServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="FileServicesName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

