/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.ImmutabilityPolicy;
import com.microsoft.azure.management.storage.ImmutabilityPolicyState;
import com.microsoft.azure.management.storage.implementation.BlobContainersInner;
import com.microsoft.azure.management.storage.implementation.IdParsingUtils;
import com.microsoft.azure.management.storage.implementation.ImmutabilityPolicyInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import rx.Observable;

@LangDefinition
class ImmutabilityPolicyImpl
extends CreatableUpdatableImpl<ImmutabilityPolicy, ImmutabilityPolicyInner, ImmutabilityPolicyImpl>
implements ImmutabilityPolicy,
ImmutabilityPolicy.Definition,
ImmutabilityPolicy.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private String containerName;
    private String cifMatch;
    private int cimmutabilityPeriodSinceCreationInDays;
    private String uifMatch;
    private int uimmutabilityPeriodSinceCreationInDays;

    ImmutabilityPolicyImpl(String name, StorageManager manager) {
        super(name, (Object)new ImmutabilityPolicyInner());
        this.manager = manager;
        this.containerName = name;
    }

    ImmutabilityPolicyImpl(ImmutabilityPolicyInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.containerName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.containerName = IdParsingUtils.getValueFromIdByName(inner.id(), "containers");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Observable<ImmutabilityPolicy> createResourceAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return client.createOrUpdateImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, this.cifMatch, this.cimmutabilityPeriodSinceCreationInDays, null).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<ImmutabilityPolicy> updateResourceAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return client.createOrUpdateImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName, this.uifMatch, this.uimmutabilityPeriodSinceCreationInDays, null).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ImmutabilityPolicyInner> getInnerAsync() {
        BlobContainersInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).blobContainers();
        return client.getImmutabilityPolicyAsync(this.resourceGroupName, this.accountName, this.containerName);
    }

    public boolean isInCreateMode() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).id() == null;
    }

    @Override
    public String etag() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).etag();
    }

    @Override
    public String id() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).id();
    }

    @Override
    public int immutabilityPeriodSinceCreationInDays() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).immutabilityPeriodSinceCreationInDays();
    }

    @Override
    public String name() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).name();
    }

    @Override
    public ImmutabilityPolicyState state() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).state();
    }

    @Override
    public String type() {
        return ((ImmutabilityPolicyInner)((Object)this.inner())).type();
    }

    @Override
    public ImmutabilityPolicyImpl withExistingContainer(String resourceGroupName, String accountName, String containerName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.containerName = containerName;
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.cifMatch = ifMatch;
        } else {
            this.uifMatch = ifMatch;
        }
        return this;
    }

    @Override
    public ImmutabilityPolicyImpl withImmutabilityPeriodSinceCreationInDays(int immutabilityPeriodSinceCreationInDays) {
        if (this.isInCreateMode()) {
            this.cimmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        } else {
            this.uimmutabilityPeriodSinceCreationInDays = immutabilityPeriodSinceCreationInDays;
        }
        return this;
    }
}

