/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.storage;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for RoutingChoice.
 */
public final class RoutingChoice extends ExpandableStringEnum<RoutingChoice> {
    /** Static value MicrosoftRouting for RoutingChoice. */
    public static final RoutingChoice MICROSOFT_ROUTING = fromString("MicrosoftRouting");

    /** Static value InternetRouting for RoutingChoice. */
    public static final RoutingChoice INTERNET_ROUTING = fromString("InternetRouting");

    /**
     * Creates or finds a RoutingChoice from its string representation.
     * @param name a name to look for
     * @return the corresponding RoutingChoice
     */
    @JsonCreator
    public static RoutingChoice fromString(String name) {
        return fromString(name, RoutingChoice.class);
    }

    /**
     * @return known RoutingChoice values
     */
    public static Collection<RoutingChoice> values() {
        return values(RoutingChoice.class);
    }
}
