/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.storage.Action;
import com.microsoft.azure.management.storage.Bypass;
import com.microsoft.azure.management.storage.DefaultAction;
import com.microsoft.azure.management.storage.IPRule;
import com.microsoft.azure.management.storage.NetworkRuleSet;
import com.microsoft.azure.management.storage.VirtualNetworkRule;
import com.microsoft.azure.management.storage.implementation.StorageAccountCreateParametersInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountInner;
import com.microsoft.azure.management.storage.implementation.StorageAccountUpdateParametersInner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

final class StorageNetworkRulesHelper {
    private static final String BYPASS_NONE_STR = Bypass.NONE.toString().toLowerCase();
    private final boolean isInCreateMode;
    private final StorageAccountInner inner;
    private final StorageAccountCreateParametersInner createParameters;
    private final StorageAccountUpdateParametersInner updateParameters;

    StorageNetworkRulesHelper(StorageAccountCreateParametersInner createParameters) {
        this.isInCreateMode = true;
        this.createParameters = createParameters;
        this.updateParameters = null;
        this.inner = null;
    }

    StorageNetworkRulesHelper(StorageAccountUpdateParametersInner updateParameters, StorageAccountInner inner) {
        this.isInCreateMode = false;
        this.createParameters = null;
        this.updateParameters = updateParameters;
        this.inner = inner;
    }

    static boolean isAccessAllowedFromAllNetworks(StorageAccountInner inner) {
        if (inner.networkRuleSet() == null || inner.networkRuleSet().defaultAction() == null) {
            return true;
        }
        return inner.networkRuleSet().defaultAction().equals((Object)DefaultAction.ALLOW);
    }

    static List<String> networkSubnetsWithAccess(StorageAccountInner inner) {
        ArrayList<String> subnetIds = new ArrayList<String>();
        if (inner.networkRuleSet() != null && inner.networkRuleSet().virtualNetworkRules() != null) {
            for (VirtualNetworkRule rule : inner.networkRuleSet().virtualNetworkRules()) {
                if (rule == null || rule.virtualNetworkResourceId() == null) continue;
                subnetIds.add(rule.virtualNetworkResourceId());
            }
        }
        return subnetIds;
    }

    static List<String> ipAddressesWithAccess(StorageAccountInner inner) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        if (inner.networkRuleSet() != null && inner.networkRuleSet().ipRules() != null) {
            for (IPRule rule : inner.networkRuleSet().ipRules()) {
                if (rule == null || rule.iPAddressOrRange() == null || rule.iPAddressOrRange().contains("/")) continue;
                ipAddresses.add(rule.iPAddressOrRange());
            }
        }
        return ipAddresses;
    }

    static List<String> ipAddressRangesWithAccess(StorageAccountInner inner) {
        ArrayList<String> ipAddressRanges = new ArrayList<String>();
        if (inner.networkRuleSet() != null && inner.networkRuleSet().ipRules() != null) {
            for (IPRule rule : inner.networkRuleSet().ipRules()) {
                if (rule == null || rule.iPAddressOrRange() == null || !rule.iPAddressOrRange().contains("/")) continue;
                ipAddressRanges.add(rule.iPAddressOrRange());
            }
        }
        return ipAddressRanges;
    }

    static boolean canReadLogEntriesFromAnyNetwork(StorageAccountInner inner) {
        if (inner.networkRuleSet() != null && inner.networkRuleSet().defaultAction() != null && inner.networkRuleSet().defaultAction().equals((Object)DefaultAction.DENY)) {
            Set<String> bypassSet = StorageNetworkRulesHelper.parseBypass(inner.networkRuleSet().bypass());
            return bypassSet.contains(Bypass.LOGGING.toString().toLowerCase());
        }
        return true;
    }

    static boolean canReadMetricsFromAnyNetwork(StorageAccountInner inner) {
        if (inner.networkRuleSet() != null && inner.networkRuleSet().defaultAction() != null && inner.networkRuleSet().defaultAction().equals((Object)DefaultAction.DENY)) {
            Set<String> bypassSet = StorageNetworkRulesHelper.parseBypass(inner.networkRuleSet().bypass());
            return bypassSet.contains(Bypass.METRICS.toString().toLowerCase());
        }
        return true;
    }

    static boolean canAccessFromAzureServices(StorageAccountInner inner) {
        if (inner.networkRuleSet() != null && inner.networkRuleSet().defaultAction() != null && inner.networkRuleSet().defaultAction().equals((Object)DefaultAction.DENY)) {
            Set<String> bypassSet = StorageNetworkRulesHelper.parseBypass(inner.networkRuleSet().bypass());
            return bypassSet.contains(Bypass.AZURE_SERVICES.toString().toLowerCase());
        }
        return true;
    }

    StorageNetworkRulesHelper withAccessFromAllNetworks() {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(true);
        networkRuleSet.withDefaultAction(DefaultAction.ALLOW);
        return this;
    }

    StorageNetworkRulesHelper withAccessFromSelectedNetworks() {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(true);
        networkRuleSet.withDefaultAction(DefaultAction.DENY);
        return this;
    }

    StorageNetworkRulesHelper withAccessFromNetworkSubnet(String subnetId) {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(true);
        if (networkRuleSet.virtualNetworkRules() == null) {
            networkRuleSet.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>());
        }
        boolean found = false;
        for (VirtualNetworkRule rule : networkRuleSet.virtualNetworkRules()) {
            if (!rule.virtualNetworkResourceId().equalsIgnoreCase(subnetId)) continue;
            found = true;
            break;
        }
        if (!found) {
            networkRuleSet.virtualNetworkRules().add(new VirtualNetworkRule().withVirtualNetworkResourceId(subnetId).withAction(Action.ALLOW));
        }
        return this;
    }

    StorageNetworkRulesHelper withAccessFromIpAddress(String ipAddress) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddress);
    }

    StorageNetworkRulesHelper withAccessFromIpAddressRange(String ipAddressCidr) {
        return this.withAccessAllowedFromIpAddressOrRange(ipAddressCidr);
    }

    StorageNetworkRulesHelper withReadAccessToLoggingFromAnyNetwork() {
        this.addToBypassList(Bypass.LOGGING);
        return this;
    }

    StorageNetworkRulesHelper withReadAccessToMetricsFromAnyNetwork() {
        this.addToBypassList(Bypass.METRICS);
        return this;
    }

    StorageNetworkRulesHelper withAccessAllowedFromAzureServices() {
        this.addToBypassList(Bypass.AZURE_SERVICES);
        return this;
    }

    StorageNetworkRulesHelper withoutNetworkSubnetAccess(String subnetId) {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(false);
        if (networkRuleSet == null || networkRuleSet.virtualNetworkRules() == null || networkRuleSet.virtualNetworkRules().size() == 0) {
            return this;
        }
        int foundIndex = -1;
        int i = 0;
        for (VirtualNetworkRule rule : networkRuleSet.virtualNetworkRules()) {
            if (rule.virtualNetworkResourceId().equalsIgnoreCase(subnetId)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            networkRuleSet.virtualNetworkRules().remove(foundIndex);
        }
        return this;
    }

    StorageNetworkRulesHelper withoutIpAddressAccess(String ipAddress) {
        return this.withoutIpAddressOrRangeAccess(ipAddress);
    }

    StorageNetworkRulesHelper withoutIpAddressRangeAccess(String ipAddressCidr) {
        return this.withoutIpAddressOrRangeAccess(ipAddressCidr);
    }

    StorageNetworkRulesHelper withoutReadAccessToLoggingFromAnyNetwork() {
        this.removeFromBypassList(Bypass.LOGGING);
        return this;
    }

    StorageNetworkRulesHelper withoutReadAccessToMetricsFromAnyNetwork() {
        this.removeFromBypassList(Bypass.METRICS);
        return this;
    }

    StorageNetworkRulesHelper withoutAccessFromAzureServices() {
        this.removeFromBypassList(Bypass.AZURE_SERVICES);
        return this;
    }

    private void addToBypassList(Bypass bypass) {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(true);
        String bypassStr = bypass.toString().toLowerCase();
        Set<String> bypassSet = StorageNetworkRulesHelper.parseBypass(networkRuleSet.bypass());
        if (bypassStr.equalsIgnoreCase(BYPASS_NONE_STR)) {
            bypassSet.clear();
            bypassSet.add(BYPASS_NONE_STR);
        } else {
            if (bypassSet.contains(BYPASS_NONE_STR)) {
                bypassSet.remove(BYPASS_NONE_STR);
            }
            bypassSet.add(bypassStr);
        }
        networkRuleSet.withBypass(Bypass.fromString(StringUtils.join(bypassSet, (String)", ")));
    }

    private void removeFromBypassList(Bypass bypass) {
        String bypassStr;
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(false);
        if (networkRuleSet == null) {
            return;
        }
        Set<String> bypassSet = StorageNetworkRulesHelper.parseBypass(networkRuleSet.bypass());
        if (bypassSet.contains(bypassStr = bypass.toString().toLowerCase())) {
            bypassSet.remove(bypassStr);
        }
        if (bypassSet.isEmpty() && !bypassStr.equalsIgnoreCase(BYPASS_NONE_STR)) {
            bypassSet.add(BYPASS_NONE_STR);
        }
        networkRuleSet.withBypass(Bypass.fromString(StringUtils.join(bypassSet, (String)", ")));
    }

    void setDefaultActionIfRequired() {
        if (this.isInCreateMode) {
            if (this.createParameters.networkRuleSet() != null) {
                boolean anyException;
                boolean hasAtLeastOneRule = false;
                if (this.createParameters.networkRuleSet().virtualNetworkRules() != null && this.createParameters.networkRuleSet().virtualNetworkRules().size() > 0) {
                    hasAtLeastOneRule = true;
                } else if (this.createParameters.networkRuleSet().ipRules() != null && this.createParameters.networkRuleSet().ipRules().size() > 0) {
                    hasAtLeastOneRule = true;
                }
                boolean bl = anyException = this.createParameters.networkRuleSet().bypass() != null;
                if ((hasAtLeastOneRule || anyException) && this.createParameters.networkRuleSet().defaultAction() == null) {
                    this.createParameters.networkRuleSet().withDefaultAction(DefaultAction.DENY);
                    if (!anyException) {
                        this.createParameters.networkRuleSet().withBypass(Bypass.NONE);
                    }
                }
            }
        } else {
            NetworkRuleSet currentRuleSet = this.inner.networkRuleSet();
            boolean hasNoExistingException = currentRuleSet != null && currentRuleSet.bypass() == null;
            boolean hasExistingRules = false;
            if (currentRuleSet != null) {
                if (currentRuleSet.virtualNetworkRules() != null && currentRuleSet.virtualNetworkRules().size() > 0) {
                    hasExistingRules = true;
                } else if (currentRuleSet.ipRules() != null && currentRuleSet.ipRules().size() > 0) {
                    hasExistingRules = true;
                }
            }
            if (!hasExistingRules && this.updateParameters.networkRuleSet() != null) {
                boolean anyExceptionAddedFirstTime;
                boolean anyRulesAddedFirstTime = false;
                if (this.updateParameters.networkRuleSet().virtualNetworkRules() != null && this.updateParameters.networkRuleSet().virtualNetworkRules().size() > 0) {
                    anyRulesAddedFirstTime = true;
                } else if (this.updateParameters.networkRuleSet().ipRules() != null && this.updateParameters.networkRuleSet().ipRules().size() > 0) {
                    anyRulesAddedFirstTime = true;
                }
                boolean bl = anyExceptionAddedFirstTime = !hasNoExistingException && this.updateParameters.networkRuleSet().bypass() != null;
                if ((anyRulesAddedFirstTime || anyExceptionAddedFirstTime) && this.updateParameters.networkRuleSet().defaultAction() == null) {
                    this.updateParameters.networkRuleSet().withDefaultAction(DefaultAction.DENY);
                    if (!anyExceptionAddedFirstTime) {
                        this.createParameters.networkRuleSet().withBypass(Bypass.NONE);
                    }
                }
            }
        }
    }

    private StorageNetworkRulesHelper withAccessAllowedFromIpAddressOrRange(String ipAddressOrRange) {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(true);
        if (networkRuleSet.ipRules() == null) {
            networkRuleSet.withIpRules(new ArrayList<IPRule>());
        }
        boolean found = false;
        for (IPRule rule : networkRuleSet.ipRules()) {
            if (!rule.iPAddressOrRange().equalsIgnoreCase(ipAddressOrRange)) continue;
            found = true;
            break;
        }
        if (!found) {
            networkRuleSet.ipRules().add(new IPRule().withIPAddressOrRange(ipAddressOrRange).withAction(Action.ALLOW));
        }
        return this;
    }

    private StorageNetworkRulesHelper withoutIpAddressOrRangeAccess(String ipAddressOrRange) {
        NetworkRuleSet networkRuleSet = this.getNetworkRuleSetConfig(false);
        if (networkRuleSet == null || networkRuleSet.ipRules() == null || networkRuleSet.ipRules().size() == 0) {
            return this;
        }
        int foundIndex = -1;
        int i = 0;
        for (IPRule rule : networkRuleSet.ipRules()) {
            if (rule.iPAddressOrRange().equalsIgnoreCase(ipAddressOrRange)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            networkRuleSet.ipRules().remove(foundIndex);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NetworkRuleSet getNetworkRuleSetConfig(boolean createIfNotExists) {
        if (this.isInCreateMode) {
            if (this.createParameters.networkRuleSet() != null) return this.createParameters.networkRuleSet();
            if (!createIfNotExists) return null;
            this.createParameters.withNetworkRuleSet(new NetworkRuleSet());
            return this.createParameters.networkRuleSet();
        }
        if (this.updateParameters.networkRuleSet() != null) return this.updateParameters.networkRuleSet();
        if (this.inner.networkRuleSet() == null) {
            if (!createIfNotExists) return null;
            this.updateParameters.withNetworkRuleSet(new NetworkRuleSet());
            return this.updateParameters.networkRuleSet();
        } else {
            Object clonedRule;
            NetworkRuleSet clonedNetworkRuleSet = new NetworkRuleSet();
            clonedNetworkRuleSet.withDefaultAction(this.inner.networkRuleSet().defaultAction());
            clonedNetworkRuleSet.withBypass(this.inner.networkRuleSet().bypass());
            if (this.inner.networkRuleSet().virtualNetworkRules() != null) {
                clonedNetworkRuleSet.withVirtualNetworkRules(new ArrayList<VirtualNetworkRule>());
                for (VirtualNetworkRule virtualNetworkRule : this.inner.networkRuleSet().virtualNetworkRules()) {
                    clonedRule = new VirtualNetworkRule().withAction(virtualNetworkRule.action()).withVirtualNetworkResourceId(virtualNetworkRule.virtualNetworkResourceId());
                    clonedNetworkRuleSet.virtualNetworkRules().add((VirtualNetworkRule)clonedRule);
                }
            }
            if (this.inner.networkRuleSet().ipRules() != null) {
                clonedNetworkRuleSet.withIpRules(new ArrayList<IPRule>());
                for (IPRule iPRule : this.inner.networkRuleSet().ipRules()) {
                    clonedRule = new IPRule().withAction(iPRule.action()).withIPAddressOrRange(iPRule.iPAddressOrRange());
                    clonedNetworkRuleSet.ipRules().add((IPRule)clonedRule);
                }
            }
            this.updateParameters.withNetworkRuleSet(clonedNetworkRuleSet);
        }
        return this.updateParameters.networkRuleSet();
    }

    private static Set<String> parseBypass(Bypass bypass) {
        if (bypass == null) {
            return new TreeSet<String>();
        }
        TreeSet<String> bypassSet = new TreeSet<String>();
        List<String> bypassStrList = Arrays.asList(bypass.toString().split(","));
        for (String s : bypassStrList) {
            if ((s = s.trim().toLowerCase()).isEmpty() || bypassSet.contains(s)) continue;
            bypassSet.add(s);
        }
        return bypassSet;
    }
}

