/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.trafficmanager.implementation.CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner;
import com.microsoft.azure.management.trafficmanager.implementation.PageImpl;
import com.microsoft.azure.management.trafficmanager.implementation.ProfileInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerNameAvailabilityInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ProfilesInner
implements InnerSupportsGet<ProfileInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ProfileInner> {
    private ProfilesService service;
    private TrafficManagerManagementClientImpl client;

    public ProfilesInner(Retrofit retrofit, TrafficManagerManagementClientImpl client) {
        this.service = (ProfilesService)retrofit.create(ProfilesService.class);
        this.client = client;
    }

    public TrafficManagerNameAvailabilityInner checkTrafficManagerRelativeDnsNameAvailability(CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner parameters) {
        return (TrafficManagerNameAvailabilityInner)((ServiceResponse)this.checkTrafficManagerRelativeDnsNameAvailabilityWithServiceResponseAsync(parameters).toBlocking().single()).body();
    }

    public ServiceFuture<TrafficManagerNameAvailabilityInner> checkTrafficManagerRelativeDnsNameAvailabilityAsync(CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner parameters, ServiceCallback<TrafficManagerNameAvailabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkTrafficManagerRelativeDnsNameAvailabilityWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<TrafficManagerNameAvailabilityInner> checkTrafficManagerRelativeDnsNameAvailabilityAsync(CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner parameters) {
        return this.checkTrafficManagerRelativeDnsNameAvailabilityWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<TrafficManagerNameAvailabilityInner>, TrafficManagerNameAvailabilityInner>(){

            public TrafficManagerNameAvailabilityInner call(ServiceResponse<TrafficManagerNameAvailabilityInner> response) {
                return (TrafficManagerNameAvailabilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<TrafficManagerNameAvailabilityInner>> checkTrafficManagerRelativeDnsNameAvailabilityWithServiceResponseAsync(CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.checkTrafficManagerRelativeDnsNameAvailability(this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TrafficManagerNameAvailabilityInner>>>(){

            public Observable<ServiceResponse<TrafficManagerNameAvailabilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.checkTrafficManagerRelativeDnsNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TrafficManagerNameAvailabilityInner> checkTrafficManagerRelativeDnsNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TrafficManagerNameAvailabilityInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProfileInner> listByResourceGroup(String resourceGroupName) {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ProfileInner>(page){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<ProfileInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<ProfileInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<List<ProfileInner>> response) {
                PageImpl<ProfileInner> page = new PageImpl<ProfileInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ProfileInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ProfileInner>>>>(){

            public Observable<ServiceResponse<List<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProfileInner> list() {
        PageImpl page = new PageImpl();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ProfileInner>(page){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listAsync(ServiceCallback<List<ProfileInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<ProfileInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<List<ProfileInner>> response) {
                PageImpl<ProfileInner> page = new PageImpl<ProfileInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ProfileInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ProfileInner>>>>(){

            public Observable<ServiceResponse<List<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProfileInner getByResourceGroup(String resourceGroupName, String profileName) {
        return (ProfileInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProfileInner createOrUpdate(String resourceGroupName, String profileName, ProfileInner parameters) {
        return (ProfileInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, profileName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> createOrUpdateAsync(String resourceGroupName, String profileName, ProfileInner parameters, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, profileName, parameters), serviceCallback);
    }

    public Observable<ProfileInner> createOrUpdateAsync(String resourceGroupName, String profileName, ProfileInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, profileName, parameters).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, ProfileInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, profileName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).register(201, new TypeToken<ProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProfileInner update(String resourceGroupName, String profileName, ProfileInner parameters) {
        return (ProfileInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> updateAsync(String resourceGroupName, String profileName, ProfileInner parameters, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, parameters), serviceCallback);
    }

    public Observable<ProfileInner> updateAsync(String resourceGroupName, String profileName, ProfileInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, parameters).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, ProfileInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.update(resourceGroupName, profileName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProfilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles checkTrafficManagerRelativeDnsNameAvailability"})
        @POST(value="providers/Microsoft.Network/checkTrafficManagerNameAvailability")
        public Observable<Response<ResponseBody>> checkTrafficManagerRelativeDnsNameAvailability(@Path(value="subscriptionId") String var1, @Body CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficmanagerprofiles")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Body ProfileInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.Profiles update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Body ProfileInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

