/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.trafficmanager.EndpointMonitorStatus;
import com.microsoft.azure.management.trafficmanager.EndpointType;
import com.microsoft.azure.management.trafficmanager.TrafficManagerEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointInner;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointsInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerProfileImpl;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TrafficManagerEndpointImpl
extends ExternalChildResourceImpl<TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile>
implements TrafficManagerEndpoint,
TrafficManagerEndpoint.Definition<TrafficManagerProfile.DefinitionStages.WithCreate>,
TrafficManagerEndpoint.UpdateDefinition<TrafficManagerProfile.Update>,
TrafficManagerEndpoint.UpdateAzureEndpoint,
TrafficManagerEndpoint.UpdateExternalEndpoint,
TrafficManagerEndpoint.UpdateNestedProfileEndpoint {
    private final EndpointsInner client;
    private final String endpointStatusDisabled = "Disabled";
    private final String endpointStatusEnabled = "Enabled";

    TrafficManagerEndpointImpl(String name, TrafficManagerProfileImpl parent, EndpointInner inner, EndpointsInner client) {
        super(name, (Object)parent, (Object)inner);
        this.client = client;
    }

    public String id() {
        return ((EndpointInner)this.inner()).id();
    }

    @Override
    public EndpointType endpointType() {
        return EndpointType.fromValue(((EndpointInner)this.inner()).type());
    }

    @Override
    public EndpointMonitorStatus monitorStatus() {
        return new EndpointMonitorStatus(((EndpointInner)this.inner()).endpointMonitorStatus());
    }

    @Override
    public boolean isEnabled() {
        return ((EndpointInner)this.inner()).endpointStatus().equalsIgnoreCase(this.endpointStatusEnabled);
    }

    @Override
    public long routingWeight() {
        return Utils.toPrimitiveLong((Long)((EndpointInner)this.inner()).weight());
    }

    @Override
    public long routingPriority() {
        return Utils.toPrimitiveLong((Long)((EndpointInner)this.inner()).priority());
    }

    @Override
    public TrafficManagerEndpointImpl toResourceId(String resourceId) {
        ((EndpointInner)this.inner()).withTargetResourceId(resourceId);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toFqdn(String externalFqdn) {
        ((EndpointInner)this.inner()).withTarget(externalFqdn);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toProfile(TrafficManagerProfile nestedProfile) {
        ((EndpointInner)this.inner()).withTargetResourceId(nestedProfile.id());
        ((EndpointInner)this.inner()).withMinChildEndpoints(new Long(1L));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl fromRegion(Region location) {
        ((EndpointInner)this.inner()).withEndpointLocation(location.toString());
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withMinimumEndpointsToEnableTraffic(int count) {
        ((EndpointInner)this.inner()).withMinChildEndpoints(new Long(count));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingPriority(int priority) {
        ((EndpointInner)this.inner()).withPriority(new Long(priority));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficDisabled() {
        ((EndpointInner)this.inner()).withEndpointStatus(this.endpointStatusDisabled);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficEnabled() {
        ((EndpointInner)this.inner()).withEndpointStatus(this.endpointStatusEnabled);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingWeight(int weight) {
        ((EndpointInner)this.inner()).withWeight(new Long(weight));
        return this;
    }

    public Observable<TrafficManagerEndpoint> createAsync() {
        final TrafficManagerEndpointImpl self = this;
        return this.client.createOrUpdateAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().localName(), this.name(), (EndpointInner)this.inner()).map((Func1)new Func1<EndpointInner, TrafficManagerEndpoint>(){

            public TrafficManagerEndpoint call(EndpointInner inner) {
                self.setInner(inner);
                return self;
            }
        });
    }

    public Observable<TrafficManagerEndpoint> updateAsync() {
        return this.createAsync();
    }

    public Observable<Void> deleteAsync() {
        return this.client.deleteAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().localName(), this.name());
    }

    public TrafficManagerProfileImpl attach() {
        return ((TrafficManagerProfileImpl)this.parent()).withEndpoint(this);
    }

    protected Observable<EndpointInner> getInnerAsync() {
        return this.client.getAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().toString(), this.name());
    }
}

