/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for MonitorProtocol.
 */
public final class MonitorProtocol {
    /** Static value HTTP for MonitorProtocol. */
    public static final MonitorProtocol HTTP = new MonitorProtocol("HTTP");

    /** Static value HTTPS for MonitorProtocol. */
    public static final MonitorProtocol HTTPS = new MonitorProtocol("HTTPS");

    /** Static value TCP for MonitorProtocol. */
    public static final MonitorProtocol TCP = new MonitorProtocol("TCP");

    private String value;

    /**
     * Creates a custom value for MonitorProtocol.
     * @param value the custom value
     */
    public MonitorProtocol(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MonitorProtocol)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MonitorProtocol rhs = (MonitorProtocol) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
