/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class representing a Traffic Manager HeatMap traffic flow properties.
 */
public class TrafficFlow {
    /**
     * The IP address that this query experience originated from.
     */
    @JsonProperty(value = "sourceIp")
    private String sourceIp;

    /**
     * The approximate latitude that these queries originated from.
     */
    @JsonProperty(value = "latitude")
    private Double latitude;

    /**
     * The approximate longitude that these queries originated from.
     */
    @JsonProperty(value = "longitude")
    private Double longitude;

    /**
     * The query experiences produced in this HeatMap calculation.
     */
    @JsonProperty(value = "queryExperiences")
    private List<QueryExperience> queryExperiences;

    /**
     * Get the IP address that this query experience originated from.
     *
     * @return the sourceIp value
     */
    public String sourceIp() {
        return this.sourceIp;
    }

    /**
     * Set the IP address that this query experience originated from.
     *
     * @param sourceIp the sourceIp value to set
     * @return the TrafficFlow object itself.
     */
    public TrafficFlow withSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
        return this;
    }

    /**
     * Get the approximate latitude that these queries originated from.
     *
     * @return the latitude value
     */
    public Double latitude() {
        return this.latitude;
    }

    /**
     * Set the approximate latitude that these queries originated from.
     *
     * @param latitude the latitude value to set
     * @return the TrafficFlow object itself.
     */
    public TrafficFlow withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    /**
     * Get the approximate longitude that these queries originated from.
     *
     * @return the longitude value
     */
    public Double longitude() {
        return this.longitude;
    }

    /**
     * Set the approximate longitude that these queries originated from.
     *
     * @param longitude the longitude value to set
     * @return the TrafficFlow object itself.
     */
    public TrafficFlow withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    /**
     * Get the query experiences produced in this HeatMap calculation.
     *
     * @return the queryExperiences value
     */
    public List<QueryExperience> queryExperiences() {
        return this.queryExperiences;
    }

    /**
     * Set the query experiences produced in this HeatMap calculation.
     *
     * @param queryExperiences the queryExperiences value to set
     * @return the TrafficFlow object itself.
     */
    public TrafficFlow withQueryExperiences(List<QueryExperience> queryExperiences) {
        this.queryExperiences = queryExperiences;
        return this;
    }

}
