/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.trafficmanager;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class representing a Traffic Manager HeatMap query experience properties.
 */
public class QueryExperience {
    /**
     * The id of the endpoint from the 'endpoints' array which these queries
     * were routed to.
     */
    @JsonProperty(value = "endpointId", required = true)
    private int endpointId;

    /**
     * The number of queries originating from this location.
     */
    @JsonProperty(value = "queryCount", required = true)
    private int queryCount;

    /**
     * The latency experienced by queries originating from this location.
     */
    @JsonProperty(value = "latency")
    private Double latency;

    /**
     * Get the id of the endpoint from the 'endpoints' array which these queries were routed to.
     *
     * @return the endpointId value
     */
    public int endpointId() {
        return this.endpointId;
    }

    /**
     * Set the id of the endpoint from the 'endpoints' array which these queries were routed to.
     *
     * @param endpointId the endpointId value to set
     * @return the QueryExperience object itself.
     */
    public QueryExperience withEndpointId(int endpointId) {
        this.endpointId = endpointId;
        return this;
    }

    /**
     * Get the number of queries originating from this location.
     *
     * @return the queryCount value
     */
    public int queryCount() {
        return this.queryCount;
    }

    /**
     * Set the number of queries originating from this location.
     *
     * @param queryCount the queryCount value to set
     * @return the QueryExperience object itself.
     */
    public QueryExperience withQueryCount(int queryCount) {
        this.queryCount = queryCount;
        return this;
    }

    /**
     * Get the latency experienced by queries originating from this location.
     *
     * @return the latency value
     */
    public Double latency() {
        return this.latency;
    }

    /**
     * Set the latency experienced by queries originating from this location.
     *
     * @param latency the latency value to set
     * @return the QueryExperience object itself.
     */
    public QueryExperience withLatency(Double latency) {
        this.latency = latency;
        return this;
    }

}
