/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.CompletableFutureUtil;
import com.microsoft.azure.relay.InputQueue;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class AsyncSemaphore {
    private final Object thisLock = new Object();
    private final ScheduledExecutorService executor;
    private final int limit;
    private InputQueue<Boolean> waiterQueue;
    private int permits;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncSemaphore(int permits, ScheduledExecutorService executor) {
        this.limit = permits;
        this.executor = executor;
        Object object = this.thisLock;
        synchronized (object) {
            if (permits < 1) {
                throw new IllegalArgumentException("The size of semaphore cannot be less than 1");
            }
            this.permits = permits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availablePermits() {
        Object object = this.thisLock;
        synchronized (object) {
            return this.permits;
        }
    }

    public CompletableFuture<LockRelease> acquireAsync() {
        return this.acquireAsync(1, null);
    }

    public CompletableFuture<LockRelease> acquireAsync(Duration timeout) {
        return this.acquireAsync(1, timeout);
    }

    public CompletableFuture<LockRelease> acquireAsync(int count) {
        return this.acquireAsync(count, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LockRelease> acquireAsync(int count, Duration timeout) {
        CompletableFuture[] releases;
        if (count > this.limit) {
            return CompletableFutureUtil.fromException(new IllegalArgumentException("Cannot acquire more than its capacity."));
        }
        Object object = this.thisLock;
        synchronized (object) {
            int acquired = Math.min(this.availablePermits(), count);
            this.permits -= acquired;
            if (acquired == count) {
                return CompletableFuture.completedFuture(new LockRelease(count));
            }
            if (this.waiterQueue == null) {
                this.waiterQueue = new InputQueue(this.executor);
            }
            releases = new CompletableFuture[count];
            for (int i = 0; i < count; ++i) {
                releases[i] = i < acquired ? CompletableFuture.completedFuture(true) : this.waiterQueue.dequeueAsync(timeout);
            }
        }
        return CompletableFuture.allOf(releases).handle((nullResult, ex) -> {
            if (ex != null) {
                for (CompletableFuture release : releases) {
                    Object object = this.thisLock;
                    synchronized (object) {
                        if (!release.isCompletedExceptionally()) {
                            this.waiterQueue.enqueueAndDispatch(true, null, false);
                        }
                    }
                }
                throw new CompletionException(ex.getCause());
            }
            Object object = this.thisLock;
            synchronized (object) {
                this.permits -= count;
            }
            return new LockRelease(count);
        });
    }

    public <T> CompletableFuture<T> acquireThenCompose(Duration timeout, Supplier<? extends CompletionStage<T>> supplier) {
        AtomicReference lockReleaseRef = new AtomicReference();
        return ((CompletableFuture)this.acquireAsync(timeout).thenCompose(lockRelease -> {
            lockReleaseRef.set(lockRelease);
            return (CompletionStage)supplier.get();
        })).whenComplete((result, ex) -> {
            LockRelease lockRelease = (LockRelease)lockReleaseRef.get();
            if (lockRelease != null) {
                lockRelease.release();
            }
        });
    }

    public <T> CompletableFuture<T> acquireThenApply(Duration timeout, Supplier<T> supplier) {
        return this.acquireAsync(timeout).thenApply(lockRelease -> {
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                lockRelease.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(int count) {
        Object object = this.thisLock;
        synchronized (object) {
            this.permits += count;
            if (this.waiterQueue != null) {
                for (int i = 0; i < count && this.waiterQueue.getReadersQueueCount() > 0; ++i) {
                    this.waiterQueue.enqueueAndDispatch(true, null, false);
                }
            }
        }
    }

    public final class LockRelease {
        private final Object thisLock = new Object();
        private int remaining;

        private LockRelease(int count) {
            this.remaining = count;
        }

        public void release() {
            this.release(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(int count) {
            Object object = this.thisLock;
            synchronized (object) {
                if (this.remaining < count) {
                    throw new IllegalArgumentException("Cannot release more than owned.");
                }
                AsyncSemaphore.this.release(count);
                this.remaining -= count;
            }
        }
    }
}

