/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.microsoft.azure.relay.SecurityToken;
import com.microsoft.azure.relay.TokenProvider;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

class AzureIdentityTokenProvider
extends TokenProvider {
    static final String AAD_RELAY_AUDIENCE = "https://relay.azure.net/";
    private final TokenRequestContext tokenRequestContext;
    private final TokenCredential tokenCredential;

    AzureIdentityTokenProvider(TokenCredential tokenCredential) {
        if (tokenCredential == null) {
            throw new IllegalArgumentException("The TokenCredential provided must not be null.");
        }
        this.tokenCredential = tokenCredential;
        this.tokenRequestContext = new TokenRequestContext();
        this.tokenRequestContext.addScopes(new String[]{String.format("%s/.default", AAD_RELAY_AUDIENCE)});
    }

    @Override
    protected CompletableFuture<SecurityToken> onGetTokenAsync(String urlString, Duration validFor) {
        return this.tokenCredential.getToken(this.tokenRequestContext).toFuture().thenApply(accessToken -> new SecurityToken(accessToken.getToken(), accessToken.getExpiresAt().toInstant(), urlString));
    }
}

