/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

final class HybridConnectionUtil {
    HybridConnectionUtil() {
    }

    static String getAudience(URI uri) {
        StringBuilder audience = new StringBuilder();
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        if (!StringUtil.isNullOrEmpty(scheme)) {
            audience.append(scheme).append("://");
        }
        if (!StringUtil.isNullOrEmpty(host)) {
            audience.append(host);
        }
        if (port > -1) {
            audience.append(":").append(port);
        }
        if (StringUtil.isNullOrEmpty(path)) {
            audience.append("/").append(path);
        }
        return audience.toString();
    }

    static URI buildUri(String host, int port, String path, String query, String action, String id) throws URISyntaxException {
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        query = HybridConnectionUtil.buildQueryString(query, action, id);
        return new URI("wss", null, host, port, "/$hc" + path, query, null);
    }

    static String buildQueryString(String existingQueryString, String action, String id) {
        StringBuilder buffer = new StringBuilder();
        if (!StringUtil.isNullOrEmpty(existingQueryString)) {
            buffer.append(existingQueryString);
            if (buffer.charAt(0) == '?') {
                buffer.deleteCharAt(0);
            }
            if (buffer.length() > 0) {
                buffer.append("&");
            }
        }
        buffer.append("sb-hc-action").append('=').append(action).append('&').append("sb-hc-id").append('=').append(id);
        return buffer.toString();
    }

    static String filterQueryString(String queryString) throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(queryString)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(queryString);
        if (buffer.charAt(0) == '?') {
            buffer.deleteCharAt(0);
        }
        Map<String, String> queryStringCollection = HybridConnectionUtil.parseQueryString(queryString);
        StringBuffer sb = new StringBuffer(256);
        for (String key : queryStringCollection.keySet()) {
            if (key == null || key.startsWith("sb-hc-")) continue;
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode(key, StringUtil.UTF8.name())).append("=").append(URLEncoder.encode(queryStringCollection.get(key), StringUtil.UTF8.name()));
        }
        return sb.toString();
    }

    static Map<String, String> parseQueryString(String query) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNullOrEmpty(query)) {
            return map;
        }
        for (String pair : pairs = query.split("&")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length == 1) {
                map.put(keyValue[0], "");
                continue;
            }
            if (keyValue.length == 2) {
                map.put(keyValue[0], keyValue[1]);
                continue;
            }
            throw new IllegalArgumentException("invalid query to be parsed.");
        }
        return map;
    }
}

