/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.RelayLogger;
import com.microsoft.azure.relay.TraceLevel;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class InputQueue<T> {
    private final ScheduledExecutorService executor;
    private final ItemQueue itemQueue;
    private final Queue<CompletableFuture<T>> readerQueue;
    private QueueState queueState;
    private final Object thisLock = new Object();

    public InputQueue(ScheduledExecutorService executor) {
        this.executor = executor;
        this.itemQueue = new ItemQueue();
        this.readerQueue = new LinkedList<CompletableFuture<T>>();
        this.queueState = QueueState.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingCount() {
        Object object = this.thisLock;
        synchronized (object) {
            return this.itemQueue.getTotalCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadersQueueCount() {
        Object object = this.thisLock;
        synchronized (object) {
            return this.readerQueue.size();
        }
    }

    public CompletableFuture<T> dequeueAsync() {
        return this.dequeueAsync(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<T> dequeueAsync(Duration timeout) {
        Item item = null;
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState == QueueState.OPEN) {
                if (!this.itemQueue.hasAvailableItem()) return this.createReader(timeout);
                item = this.itemQueue.dequeueAvailableItem();
            } else if (this.queueState == QueueState.SHUTDOWN) {
                if (this.itemQueue.hasAvailableItem()) {
                    item = this.itemQueue.dequeueAvailableItem();
                } else if (this.itemQueue.hasAnyItem()) {
                    return this.createReader(timeout);
                }
            }
        }
        this.invokeDequeuedCallback(item);
        CompletableFuture future = new CompletableFuture();
        if (item != null && item.getException() != null) {
            future.completeExceptionally(item.getException());
            return future;
        }
        future.complete(item != null ? (Object)item.getValue() : null);
        return future;
    }

    private CompletableFuture<T> createReader(Duration timeout) {
        CompletableFuture reader = new CompletableFuture();
        if (timeout != null) {
            ScheduledFuture<?> cancelTask = this.executor.schedule(() -> {
                if (this.removeReader(reader)) {
                    reader.completeExceptionally(new TimeoutException("This InputQueue item could not complete in time."));
                }
            }, timeout.toMillis(), TimeUnit.MILLISECONDS);
            reader.thenRunAsync(() -> cancelTask.cancel(true));
        }
        this.readerQueue.add(reader);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        CompletableFuture reader = null;
        CompletableFuture[] outstandingReaders = null;
        Item item = new Item();
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState != QueueState.CLOSED) {
                this.itemQueue.makePendingItemAvailable();
                if (this.readerQueue.size() > 0) {
                    item = this.itemQueue.dequeueAvailableItem();
                    reader = this.readerQueue.remove();
                    if (this.queueState == QueueState.SHUTDOWN && this.readerQueue.size() > 0 && this.itemQueue.getTotalCount() == 0) {
                        outstandingReaders = (CompletableFuture[])Array.newInstance(CompletableFuture.class, this.readerQueue.size());
                        int i = 0;
                        while (!this.readerQueue.isEmpty()) {
                            outstandingReaders[i++] = this.readerQueue.remove();
                        }
                    }
                }
            }
        }
        if (outstandingReaders != null) {
            CompletableFuture[] outstandingReadersRef = outstandingReaders;
            this.executor.submit(() -> this.completeOutstandingReadersCallback(outstandingReadersRef));
        }
        if (reader != null) {
            this.invokeDequeuedCallback(item);
            reader.complete(item.getValue());
        }
    }

    public void enqueueAndDispatch(T item) {
        this.enqueueAndDispatch(item, null);
    }

    public void enqueueAndDispatch(T item, Consumer<T> dequeuedCallback) {
        this.enqueueAndDispatch(item, dequeuedCallback, true);
    }

    public void enqueueAndDispatch(T item, Consumer<T> dequeuedCallback, boolean canDispatchOnThisThread) {
        this.enqueueAndDispatch(new Item(item, dequeuedCallback), canDispatchOnThisThread);
    }

    public boolean enqueueWithoutDispatch(T item, Consumer<T> dequeuedCallback) {
        return this.enqueueWithoutDispatch(new Item(item, dequeuedCallback));
    }

    public boolean enqueueWithoutDispatch(Exception exception, Consumer<T> dequeuedCallback) {
        return this.enqueueWithoutDispatch(new Item(exception, dequeuedCallback));
    }

    public void shutdown() {
        this.shutdown(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Supplier<Exception> pendingExceptionGenerator) {
        CompletableFuture[] outstandingReaders = null;
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState == QueueState.SHUTDOWN || this.queueState == QueueState.CLOSED) {
                return;
            }
            this.queueState = QueueState.SHUTDOWN;
            if (this.readerQueue.size() > 0 && this.itemQueue.getTotalCount() == 0) {
                outstandingReaders = (CompletableFuture[])Array.newInstance(CompletableFuture.class, this.readerQueue.size());
                int i = 0;
                while (!this.readerQueue.isEmpty()) {
                    outstandingReaders[i++] = this.readerQueue.remove();
                }
            }
        }
        if (outstandingReaders != null) {
            for (int i = 0; i < outstandingReaders.length; ++i) {
                Exception exception;
                Exception exception2 = exception = pendingExceptionGenerator != null ? pendingExceptionGenerator.get() : null;
                if (exception == null) {
                    outstandingReaders[i].complete(null);
                    continue;
                }
                outstandingReaders[i].completeExceptionally(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean dispose = false;
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState != QueueState.CLOSED) {
                this.queueState = QueueState.CLOSED;
                dispose = true;
            }
        }
        if (dispose) {
            while (this.readerQueue.size() > 0) {
                CompletableFuture<Object> reader = this.readerQueue.remove();
                reader.complete(null);
            }
            while (this.itemQueue.hasAnyItem()) {
                Item item = this.itemQueue.dequeueAnyItem();
                this.invokeDequeuedCallback(item);
            }
        }
    }

    void completeOutstandingReadersCallback(CompletableFuture<T>[] outstandingReaders) {
        for (int i = 0; i < outstandingReaders.length; ++i) {
            outstandingReaders[i].complete(null);
        }
    }

    void invokeDequeuedCallback(Item item) {
        if (item != null && item.getDequeuedCallback() != null) {
            item.dequeuedCallback.accept(item.getValueWithException());
        }
    }

    void invokeDequeuedCallbackLater(Item item) {
        if (item != null && item.getDequeuedCallback() != null) {
            this.executor.submit(() -> this.onInvokeDequeuedCallback(item));
        }
    }

    void onDispatchCallback(Object state) {
        ((InputQueue)state).dispatch();
    }

    void onInvokeDequeuedCallback(Object state) {
        Item item = (Item)state;
        item.getDequeuedCallback().accept(item.getValueWithException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAndDispatch(Item item, boolean canDispatchOnThisThread) {
        boolean disposeItem = false;
        CompletableFuture reader = null;
        boolean dispatchLater = false;
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState == QueueState.OPEN) {
                if (canDispatchOnThisThread) {
                    if (this.readerQueue.size() == 0) {
                        this.itemQueue.enqueueAvailableItem(item);
                    } else {
                        reader = this.readerQueue.remove();
                    }
                } else if (this.readerQueue.size() == 0) {
                    this.itemQueue.enqueueAvailableItem(item);
                } else {
                    this.itemQueue.enqueuePendingItem(item);
                    dispatchLater = true;
                }
            } else {
                disposeItem = true;
            }
        }
        if (reader != null) {
            this.invokeDequeuedCallback(item);
            reader.complete(item.getValue());
        }
        if (dispatchLater) {
            this.executor.submit(() -> this.onDispatchCallback(this));
        } else if (disposeItem) {
            this.invokeDequeuedCallback(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueWithoutDispatch(Item item) {
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState != QueueState.CLOSED && this.queueState != QueueState.SHUTDOWN) {
                if (this.readerQueue.size() == 0) {
                    this.itemQueue.enqueueAvailableItem(item);
                    return false;
                }
                this.itemQueue.enqueuePendingItem(item);
                return true;
            }
        }
        this.invokeDequeuedCallbackLater(item);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeReader(CompletableFuture<T> reader) {
        Object object = this.thisLock;
        synchronized (object) {
            if (this.queueState == QueueState.OPEN || this.queueState == QueueState.SHUTDOWN) {
                return this.readerQueue.remove(reader);
            }
        }
        return false;
    }

    private class ItemQueue {
        private int head;
        private Item[] items = (Item[])Array.newInstance(Item.class, 1);
        private int pendingCount;
        private int totalCount;

        ItemQueue() {
        }

        int getTotalCount() {
            return this.totalCount;
        }

        boolean hasAnyItem() {
            return this.totalCount > 0;
        }

        boolean hasAvailableItem() {
            return this.totalCount > this.pendingCount;
        }

        Item dequeueAnyItem() {
            if (this.pendingCount == this.totalCount) {
                --this.pendingCount;
            }
            return this.dequeueItemCore();
        }

        Item dequeueAvailableItem() {
            if (this.totalCount == this.pendingCount) {
                throw new RuntimeException("ItemQueue does not contain any available items");
            }
            return this.dequeueItemCore();
        }

        void enqueueAvailableItem(Item item) {
            this.enqueueItemCore(item);
        }

        void enqueuePendingItem(Item item) {
            this.enqueueItemCore(item);
            ++this.pendingCount;
        }

        void makePendingItemAvailable() {
            if (this.pendingCount == 0) {
                throw RelayLogger.invalidOperation("ItemQueue does not contain any pending items", this);
            }
            --this.pendingCount;
        }

        Item dequeueItemCore() {
            if (this.totalCount == 0) {
                throw RelayLogger.invalidOperation("ItemQueue does not contain any items", this);
            }
            Item item = this.items[this.head];
            this.items[this.head] = new Item();
            --this.totalCount;
            this.head = (this.head + 1) % this.items.length;
            return item;
        }

        void enqueueItemCore(Item item) {
            if (this.totalCount == this.items.length) {
                Item[] newItems = (Item[])Array.newInstance(Item.class, this.items.length * 2);
                for (int i = 0; i < this.totalCount; ++i) {
                    newItems[i] = this.items[(this.head + i) % this.items.length];
                }
                this.head = 0;
                this.items = newItems;
            }
            int tail = (this.head + this.totalCount) % this.items.length;
            this.items[tail] = item;
            ++this.totalCount;
        }
    }

    private static enum QueueState {
        OPEN,
        SHUTDOWN,
        CLOSED;

    }

    private class Item {
        private Consumer<T> dequeuedCallback;
        private Exception exception;
        private T value;

        Item() {
            this(null, null, null);
        }

        Item(T value, Consumer<T> dequeuedCallback) {
            this(value, null, dequeuedCallback);
        }

        Item(Exception exception, Consumer<T> dequeuedCallback) {
            this(null, exception, dequeuedCallback);
        }

        Item(T value, Exception exception, Consumer<T> dequeuedCallback) {
            this.value = value;
            this.exception = exception;
            this.dequeuedCallback = dequeuedCallback;
        }

        Consumer<T> getDequeuedCallback() {
            return this.dequeuedCallback;
        }

        Exception getException() {
            return this.exception;
        }

        T getValue() {
            return this.value;
        }

        T getValueWithException() {
            if (this.exception != null) {
                throw RelayLogger.throwingException(this.exception, this, TraceLevel.WARNING);
            }
            return this.value;
        }
    }
}

