/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

class ListenerCommand {
    private static final String ACCEPT = "accept";
    private static final String RENEW_TOKEN = "renewToken";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String INJECT_FAULT = "injectFault";
    private AcceptCommand accept;
    private RenewTokenCommand renewToken;
    private RequestCommand request;
    private ResponseCommand response;
    private InjectFaultCommand injectFault;

    ListenerCommand(JSONObject json) {
        if (json == null || json.isEmpty()) {
            return;
        }
        Iterator commands = json.keys();
        block14: while (commands.hasNext()) {
            String command;
            switch (command = (String)commands.next()) {
                case "accept": {
                    this.accept = new AcceptCommand(json.getJSONObject(ACCEPT));
                    continue block14;
                }
                case "renewToken": {
                    this.renewToken = new RenewTokenCommand(json.getJSONObject(RENEW_TOKEN));
                    continue block14;
                }
                case "request": {
                    this.request = new RequestCommand(json.getJSONObject(REQUEST));
                    continue block14;
                }
                case "response": {
                    this.response = new ResponseCommand(json.getJSONObject(RESPONSE));
                    continue block14;
                }
                case "injectFault": {
                    this.injectFault = new InjectFaultCommand();
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Invalid command type received.");
        }
    }

    AcceptCommand getAccept() {
        return this.accept;
    }

    RenewTokenCommand getRenewToken() {
        return this.renewToken;
    }

    RequestCommand getRequest() {
        return this.request;
    }

    ResponseCommand getResponse() {
        return this.response;
    }

    InjectFaultCommand getInjectFault() {
        return this.injectFault;
    }

    void setAccept(AcceptCommand accept) {
        this.accept = accept;
    }

    void setRenewToken(RenewTokenCommand renewToken) {
        this.renewToken = renewToken;
    }

    void setRequest(RequestCommand request) {
        this.request = request;
    }

    void setResponse(ResponseCommand response) {
        this.response = response;
    }

    void setInjectFault(InjectFaultCommand injectFault) {
        this.injectFault = injectFault;
    }

    class AcceptCommand {
        private String address;
        private String id;
        private Map<String, String> connectHeaders;
        private Endpoint remoteEndpoint;

        String getAddress() {
            return this.address;
        }

        void setAddress(String address) {
            this.address = address;
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        Map<String, String> getConnectHeaders() {
            if (this.connectHeaders == null) {
                this.connectHeaders = new HashMap<String, String>();
            }
            return this.connectHeaders;
        }

        void setConnectHeaders(Map<String, String> connectHeaders) {
            this.connectHeaders = connectHeaders;
        }

        Endpoint getRemoteEndpoint() {
            if (this.remoteEndpoint == null) {
                this.remoteEndpoint = new Endpoint();
            }
            return this.remoteEndpoint;
        }

        void setRemoteEndpoint(Endpoint remoteEndpoint) {
            this.remoteEndpoint = remoteEndpoint;
        }

        AcceptCommand(JSONObject json) {
            this.address = json.optString("address");
            this.id = json.optString("id");
            this.remoteEndpoint = new Endpoint(json.getJSONObject("remoteEndpoint"));
            Map headers = json.getJSONObject("connectHeaders").toMap();
            this.connectHeaders = new HashMap<String, String>();
            headers.forEach((k, v) -> this.connectHeaders.put((String)k, (String)v));
        }
    }

    class RenewTokenCommand {
        static final String TOKEN_NAME = "token";
        private String token;

        String getToken() {
            return this.token;
        }

        void setToken(String token) {
            this.token = token;
        }

        RenewTokenCommand(JSONObject json) {
            if (json != null) {
                this.token = json.optString(TOKEN_NAME);
            }
        }

        String toJsonString() {
            return "{\"renewToken\":{\"token\":\"" + this.token + "\"}}";
        }
    }

    class RequestCommand {
        private String address;
        private String id;
        private String requestTarget;
        private String method;
        private Endpoint remoteEndpoint;
        private Map<String, String> requestHeaders;
        private Boolean body;

        String getAddress() {
            return this.address;
        }

        void setAddress(String address) {
            this.address = address;
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        String getRequestTarget() {
            return this.requestTarget;
        }

        void setRequestTarget(String requestTarget) {
            this.requestTarget = requestTarget;
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        Endpoint getRemoteEndpoint() {
            if (this.remoteEndpoint == null) {
                this.remoteEndpoint = new Endpoint();
            }
            return this.remoteEndpoint;
        }

        void setRemoteEndpoint(Endpoint remoteEndpoint) {
            this.remoteEndpoint = remoteEndpoint;
        }

        Map<String, String> getRequestHeaders() {
            if (this.requestHeaders == null) {
                this.requestHeaders = new HashMap<String, String>();
            }
            return this.requestHeaders;
        }

        void setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        Boolean hasBody() {
            return this.body;
        }

        void setBody(Boolean body) {
            this.body = body;
        }

        RequestCommand(JSONObject json) {
            this.address = json.optString("address");
            this.id = json.optString("id");
            this.requestTarget = json.optString("requestTarget");
            this.method = json.optString("method");
            this.body = json.has("body") ? Boolean.valueOf(json.optBoolean("body")) : null;
            Endpoint endpoint = this.remoteEndpoint = json.has("remoteEndpoint") ? new Endpoint(json.getJSONObject("remoteEndpoint")) : null;
            if (json.has("requestHeaders")) {
                Map headers = json.getJSONObject("requestHeaders").toMap();
                this.requestHeaders = new HashMap<String, String>();
                headers.forEach((k, v) -> this.requestHeaders.put((String)k, (String)v));
            }
        }
    }

    class ResponseCommand {
        private String requestId;
        private int statusCode;
        private String statusDescription;
        private Map<String, String> responseHeaders;
        private boolean body;

        String getRequestId() {
            return this.requestId;
        }

        void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        int getStatusCode() {
            return this.statusCode;
        }

        void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        String getStatusDescription() {
            return this.statusDescription;
        }

        void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        Map<String, String> getResponseHeaders() {
            if (this.responseHeaders == null) {
                this.responseHeaders = new HashMap<String, String>();
            }
            return this.responseHeaders;
        }

        void setResponseHeaders(Map<String, String> responseHeaders) {
            this.responseHeaders = responseHeaders;
        }

        boolean hasBody() {
            return this.body;
        }

        void setBody(boolean body) {
            this.body = body;
        }

        ResponseCommand() {
        }

        ResponseCommand(JSONObject json) {
            this.requestId = json.getString("id");
            this.statusCode = json.getInt("statusCode");
            this.statusDescription = json.optString("statusDescription");
            this.body = json.getBoolean("body");
            Map headers = json.optJSONObject("responseHeaders").toMap();
            this.responseHeaders = new HashMap<String, String>();
            if (headers != null) {
                headers.forEach((k, v) -> this.responseHeaders.put((String)k, (String)v));
            }
        }

        String toJsonString() {
            StringBuilder builder = new StringBuilder("{\"response\":{");
            ArrayList<String> fields = new ArrayList<String>();
            if (this.requestId != null) {
                fields.add("\"requestId\":\"" + this.requestId + "\"");
            }
            fields.add("\"body\":" + (this.body ? "true" : "false"));
            fields.add("\"statusCode\":" + this.statusCode);
            if (this.statusDescription != null) {
                HashMap<String, String> descriptionMap = new HashMap<String, String>();
                descriptionMap.put("statusDescription", this.statusDescription);
                String description = new JSONObject(descriptionMap).toString();
                fields.add(description.substring(1, description.length() - 1));
            }
            if (this.responseHeaders != null && !this.responseHeaders.isEmpty()) {
                StringBuilder headerBuilder = new StringBuilder("\"responseHeaders\":");
                headerBuilder.append(new JSONObject(this.responseHeaders).toString());
                fields.add(headerBuilder.toString());
            }
            builder.append(String.join((CharSequence)",", fields)).append("}}");
            return builder.toString();
        }
    }

    class InjectFaultCommand {
        private Duration delay;

        InjectFaultCommand() {
        }

        Duration getDelay() {
            return this.delay;
        }

        void setDelay(Duration delay) {
            this.delay = delay;
        }
    }

    class Endpoint {
        private String address;
        private int port;

        String getAddress() {
            return this.address;
        }

        void setAddress(String address) {
            this.address = address;
        }

        int getPort() {
            return this.port;
        }

        void setPort(int port) {
            this.port = port;
        }

        Endpoint() {
        }

        Endpoint(JSONObject json) {
            this.port = json.optInt("port");
            this.address = json.optString("address");
        }
    }
}

