/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.ListenerCommand;
import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public final class RelayedHttpListenerRequest {
    private final String httpMethod;
    private final URI uri;
    private ByteArrayInputStream inputStream;
    private Map<String, String> headers;
    private boolean hasEntityBody;
    private InetSocketAddress remoteEndPoint;

    RelayedHttpListenerRequest(URI uri, String method, Map<String, String> requestHeaders) {
        this.httpMethod = method;
        this.uri = uri;
        this.inputStream = null;
        this.headers = new HashMap<String, String>();
        requestHeaders.forEach((k, v) -> this.headers.put((String)k, (String)v));
    }

    boolean hasEntityBody() {
        return this.hasEntityBody;
    }

    void setHasEntityBody(boolean hasEntityBody) {
        this.hasEntityBody = hasEntityBody;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public ByteArrayInputStream getInputStream() {
        return this.inputStream;
    }

    void setInputStream(ByteArrayInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public InetSocketAddress getRemoteEndPoint() {
        return this.remoteEndPoint;
    }

    void setRemoteEndPoint(ListenerCommand.Endpoint remoteEndpoint) {
        if (remoteEndpoint != null) {
            InetSocketAddress inetAddress;
            this.remoteEndPoint = inetAddress = new InetSocketAddress(remoteEndpoint.getAddress(), remoteEndpoint.getPort());
        }
    }
}

