/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.relay;

import com.microsoft.azure.relay.StringUtil;
import java.time.Instant;

public class SecurityToken {
    private final String token;
    private Instant expiresAtUtc;
    private String audience;

    SecurityToken(String tokenString) {
        this(tokenString, null, null);
    }

    SecurityToken(String tokenString, Instant expiresAtUtc, String audience) {
        if (StringUtil.isNullOrEmpty(tokenString)) {
            throw new IllegalArgumentException("Cannot create a SecurityToken with a null or empty token string");
        }
        this.token = tokenString;
        this.expiresAtUtc = expiresAtUtc;
        this.audience = audience;
    }

    public String getToken() {
        return this.token;
    }

    public Instant getExpiresAtUtc() {
        return this.expiresAtUtc;
    }

    protected void setExiresAtUtc(Instant expiresAt) {
        this.expiresAtUtc = expiresAt;
    }

    public String getAudience() {
        return this.audience;
    }

    protected void setAudience(String audience) {
        this.audience = audience;
    }
}

